/**
 * Login-Logs
 *
 * @module package/quiqqer/login-logger/bin/controls/Panel
 */

define('package/quiqqer/login-logger/bin/controls/Panel', [
    'qui/QUI',
    'qui/controls/desktop/Panel',
    'controls/grid/Grid',
    'Ajax',
    'Locale',

    'package/quiqqer/login-logger/bin/classes/Utils',

    'css!package/quiqqer/login-logger/bin/controls/Panel.css'
], function (QUI, Panel, Grid, QUIAjax, Locale, UtilsClass) {
    "use strict";

    var lg = 'quiqqer/login-logger';

    var Utils = new UtilsClass();

    /**
     * @class package/quiqqer/login-logger/bin/controls/Panel
     */
    return new Class({

        Extends: Panel,
        Type   : 'package/quiqqer/login-logger/bin/controls/Panel',

        Binds: [
            '$onCreate',
            'loadLoginLogs'
        ],

        initialize: function (options) {
            this.setAttributes({
                title: Locale.get(lg, 'panel.title'),
                icon : 'fa fa-log-in'
            });

            this.parent(options);

            this.$Grid = null;

            this.addEvents({
                onCreate : this.$onCreate,
                onDestroy: this.$onDestroy,
                onResize : this.$onResize
            });
        },

        /**
         * event : on create
         * build the panel
         */
        $onCreate: function () {
            this.getContent().id = 'kartoffelsuppe';
            this.getContent().setStyle('padding', 0);

            this.$Grid = new Grid(this.getContent(), {
                columnModel: [{
                    header   : Locale.get(lg, 'table.header.date'),
                    dataIndex: 'date',
                    dataType : 'date',
                    width    : 150
                }, {
                    header   : Locale.get(lg, 'table.header.username'),
                    dataIndex: 'username',
                    dataType : 'string',
                    width    : 150
                }, {
                    header   : Locale.get(lg, 'table.header.uid'),
                    dataIndex: 'uid',
                    dataType : 'int',
                    width    : 100
                }, {
                    header   : Locale.get(lg, 'table.header.ip'),
                    dataIndex: 'ip',
                    dataType : 'string',
                    width    : 100
                }, {
                    header   : Locale.get(lg, 'table.header.successful'),
                    dataIndex: 'successful',
                    dataType : 'node',
                    width    : 50
                }, {
                    header   : Locale.get(lg, 'table.header.user_data'),
                    dataIndex: 'user_data',
                    dataType : 'string',
                    width    : 100
                }, {
                    header   : Locale.get(lg, 'table.header.type'),
                    dataIndex: 'type',
                    dataType : 'string',
                    width    : 100
                }],
                pagination : true,
                perPage    : 20,
                onrefresh  : this.loadLoginLogs,
                serverSort : true,
                sortOn     : 'date',
                sortBy     : 'DESC'
            });

            this.loadLoginLogs();
        },

        /**
         * Queries the logins from the server and writes them to the grid.
         */
        loadLoginLogs: function () {
            var self = this;

            QUIAjax.get('package_quiqqer_login-logger_ajax_getLoginsForGrid', function (result) {
                self.$Grid.setData({
                    data : Utils.convertSuccessStatusToIconElement(result.data),
                    page : result.page,
                    total: result.total
                });
            }, {
                sortOn : this.$Grid.getAttribute('sortOn'),
                sortBy : this.$Grid.getAttribute('sortBy'),
                page   : this.$Grid.getAttribute('page'),
                perPage: this.$Grid.getAttribute('perPage'),
                package: 'quiqqer/login-logger'
            });
        },

        /**
         * Called when the panel is resized.
         */
        $onResize: function () {
            if (!this.$Grid) {
                return;
            }

            var Content = this.getContent();

            if (!Content) {
                return;
            }

            var size = Content.getSize();

            this.$Grid.setHeight(size.y - 10);

            this.$Grid.setWidth(size.x - 10);
        },

        /**
         * Called when the panel is destroyed.
         */
        $onDestroy: function () {
            this.$Grid.destroy();
        }
    });
});
