<?php

/**
 * @author PCSG (Jan Wennrich)
 */

namespace QUI\LoginLogger;

use QUI\Database\Exception;
use QUI\System\Log;

/**
 * Class Cron
 *
 * @package QUI\LoginLogger
 */
class Cron
{
    /**
     * Should only be called by a CRON.
     * Removes all logs older than a given amount of days (120 by default).
     *
     * Use LoginLogger::deleteLoginsOlderThanDays(), if you're not a CRON.
     *
     * @param $params
     * @param $CronManager
     *
     * @return void
     */
    public static function purgeLog($params, $CronManager): void
    {
        $maxAge = 120;

        if (isset($params['max_age']) && \is_numeric($params['max_age'])) {
            $maxAge = $params['max_age'];
        }

        try {
            LoginLogger::deleteLoginsOlderThanDays($maxAge);
        } catch (Exception $Exception) {
            Log::writeException($Exception);
        }
    }
}
