<?php

/**
 * @author PCSG (Jan Wennrich)
 */

namespace QUI\LoginLogger;

use QUI;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class Utils
 *
 * @package QUI\LoginLogger
 */
class Utils
{
    /**
     * Returns the username from a login-request.
     * If no request is given the current request is <used.
     *
     * Returns an empty string on error.
     *
     * @param Request|null $Request
     *
     * @return string
     */
    public static function getUsernameFromLoginRequest(Request $Request = null): string
    {
        if (is_null($Request)) {
            $Request = QUI::getRequest();
        }

        $params = $Request->get('params');

        if (!$params) {
            return "";
        }

        $params = json_decode($params, true);

        if (!isset($params['username'])) {
            return "";
        }

        return $params['username'];
    }
}
