<?php

/**
 * This file contains package_quiqqer_login-logger_ajax_getLoginsForGrid
 */

use QUI\LoginLogger\LoginLogger;

/**
 * Returns the logins for the grid in the panel.
 *
 * @return array
 */
QUI::$Ajax->registerFunction(
    'package_quiqqer_login-logger_ajax_getLoginsForGrid',
    function (int $page = 1, int $perPage = 50, string $sortOn = 'date', string $sortBy = 'DESC') {
        $logins = LoginLogger::getLogins([
            'order' => "$sortOn $sortBy"
        ]);

        return QUI\Utils\Grid::getResult($logins, $page, $perPage);
    },
    ['page', 'perPage', 'sortOn', 'sortBy'],
    'Permission::checkAdminUser'
);
