/**
 * Utility-Methods for the Login-Logger-Controls.
 *
 * @module package/quiqqer/login-logger/bin/classes/Utils
 * @author www.pcsg.de (Jan Wennrich)
 *
 */
define('package/quiqqer/login-logger/bin/classes/Utils', [], function () {
    "use strict";

    return new Class({

        Type: 'package/quiqqer/login-logger/bin/classes/Utils',

        /**
         * Takes an array of server-data (e.g. from an Ajax-call).
         * Converts the success value of each array-element to a font-awesome-icon.
         *
         * Could be used with a Grid, for example.
         *
         * @param {array} data
         *
         * @return {array}
         */
        convertSuccessStatusToIconElement: function (data) {
            return data.map(function (login) {
                var Icon = new Element('span', {'class': 'fa'});

                Icon.addClass(login.successful ? 'fa-check' : 'fa-times');

                login.successful = Icon;

                return login;
            });
        }
    });
});
