<?php

/**
 * This file contains package_quiqqer_payment-transactions_ajax_backend_IncomingPayments_addTransaction
 */

use QUI\ERP\Accounting\Payments\Payments;
use QUI\ERP\Accounting\Payments\Transactions\Factory as TransactionFactory;
use QUI\ERP\Accounting\Payments\Transactions\Handler as TransactionHandler;
use QUI\ERP\ErpTransactionsInterface;

QUI::$Ajax->registerFunction(
    'package_quiqqer_payment-transactions_ajax_backend_IncomingPayments_addTransaction',
    function ($uuid, $amount, $paymentMethod, $date, $txId) {
        $Entity = (new QUI\ERP\Processes())->getEntity($uuid);

        if (!($Entity instanceof ErpTransactionsInterface)) {
            return;
        }

        if (!empty($txId)) {
            $transaction = TransactionHandler::getInstance()->get($txId);
            $Entity->linkTransaction($transaction);
            return;
        }

        $Payment = Payments::getInstance()->getPayment($paymentMethod);

        // create the transaction
        TransactionFactory::createPaymentTransaction(
            $amount,
            QUI\ERP\Defaults::getCurrency(),
            $Entity->getUUID(),
            $Payment->getPaymentType()->getName(),
            [],
            QUI::getUserBySession(),
            $date,
            $Entity->getGlobalProcessId()
        );
    },
    ['uuid', 'amount', 'paymentMethod', 'date', 'txId'],
    ['Permission::checkAdminUser', 'quiqqer.paymentTransactions.create']
);
