<?php

/**
 * This file contains package_quiqqer_payment-transactions_ajax_backend_IncomingPayments_getLinkedEntities
 */

use QUI\ERP\Process;

QUI::$Ajax->registerFunction(
    'package_quiqqer_payment-transactions_ajax_backend_IncomingPayments_getLinkedEntities',
    function ($globalProcessId) {
        $Process = new Process($globalProcessId);
        $filterEntities = function ($Entity) {
            if (
                class_exists('QUI\ERP\Accounting\Invoice\InvoiceTemporary')
                && $Entity instanceof QUI\ERP\Accounting\Invoice\InvoiceTemporary
            ) {
                return false;
            }

            if (
                class_exists('QUI\ERP\Accounting\Invoice\Invoice')
                && $Entity instanceof QUI\ERP\Accounting\Invoice\Invoice
            ) {
                // ignore storno
                if (
                    $Entity->getAttribute('paid_status') == QUI\ERP\Constants::PAYMENT_STATUS_CANCELED
                    || $Entity->getAttribute('paid_status') == QUI\ERP\Constants::PAYMENT_STATUS_PAID
                ) {
                    return false;
                }
            }

            return true;
        };

        return $Process->getGroupedRelatedTransactionEntities($filterEntities);
    },
    ['globalProcessId'],
    'Permission::checkAdminUser'
);
