/**
 * @module package/quiqqer/payment-transactions/bin/backend/controls/Panel
 *
 * List all transactions in a grid
 */
define('package/quiqqer/payment-transactions/bin/backend/controls/Panel', [
    'qui/controls/desktop/Panel',
    'qui/controls/buttons/Button',
    'package/quiqqer/payment-transactions/bin/backend/controls/TransactionsGrid',
    'Ajax',
    'Locale',

    'css!package/quiqqer/payment-transactions/bin/backend/controls/Panel.css'
], function (QUIPanel, QUIButton, TransactionsGrid, QUIAjax, QUILocale) {
    'use strict';

    const lg = 'quiqqer/payment-transactions';

    return new Class({

        Extends: QUIPanel,
        Type: 'package/quiqqer/payment-transactions/bin/backend/controls/Panel',

        Binds: [
            'refresh',
            'openAdd',
            '$onCreate',
            '$onInject',
            'openRefund'
        ],

        options: {
            title: QUILocale.get(lg, 'menu.erp.payment-transactions.title'),
            icon: 'fa fa-money'
        },

        initialize: function (options) {
            this.parent(options);

            this.$Grid = null;
            this.$ButtonRefund = null;

            this.addEvents({
                onCreate: this.$onCreate,
                onInject: this.$onInject,
                onResize: this.$onResize
            });
        },

        /**
         * event : on create
         */
        $onCreate: function () {
            const self = this;

            // Buttons
            this.addButton({
                name: 'add',
                text: QUILocale.get('quiqqer/core', 'add'),
                textimage: 'fa fa-plus',
                events: {
                    onClick: this.openAdd
                }
            });
            /*
                        this.addButton({
                            type: 'separator'
                        });
              */
            // this.addButton({
            //     name     : 'remove',
            //     text     : 'Korrektur', // #locale
            //     textimage: 'fa fa-trash-o',
            //     disabled : true,
            //     events   : {
            //         onClick: this.openRemove
            //     }
            // });

            const Actions = new QUIButton({
                name: 'actions',
                text: QUILocale.get(lg, 'btn.actions'),
                menuCorner: 'topRight',
                styles: {
                    'float': 'right'
                }
            });

            Actions.appendChild({
                name: 'refund',
                icon: 'fa fa-money',
                text: QUILocale.get(lg, 'btn.refund'),
                disabled: true,
                events: {
                    onClick: function () {
                        self.openRefund(
                            self.$Grid.getSelectedData()[0].txid
                        );
                    }
                }
            });

            this.addButton(Actions);

            this.$ButtonRefund = Actions.getChildren('refund')[0];

            // Grid
            const Container = new Element('div').inject(
                this.getContent()
            );

            const TransactionGridControl = new TransactionsGrid().inject(Container);
            this.$Grid = TransactionGridControl.getGrid();

            this.$Grid.addEvents({
                onClick: function () {
                    self.$ButtonRefund.enable();
                }
            });
        },

        /**
         * Refresh
         */
        $onInject: function () {
            this.refresh();
        },

        /**
         * event : on resize
         */
        $onResize: function () {
            if (!this.$Grid) {
                return;
            }

            const Body = this.getContent();

            if (!Body) {
                return;
            }

            const size = Body.getSize();

            this.$Grid.setHeight(size.y - 40);
            this.$Grid.setWidth(size.x - 40);
        },

        /**
         * refresh the data
         *
         * @return {Promise|*}
         */
        refresh: function () {
            const self = this;

            self.$ButtonRefund.disable();

            return new Promise(function (resolve, reject) {
                QUIAjax.get('package_quiqqer_payment-transactions_ajax_backend_list', function (result) {
                    let i, len, icon;

                    for (i = 0, len = result.grid.data.length; i < len; i++) {
                        icon = 'fa fa-minus';

                        switch (parseInt(result.grid.data[i].status)) {

                            case 1:
                                icon = 'fa fa-check';
                                break;

                            case 2:
                                icon = 'fa fa-clock-o';
                                break;

                            case 3:
                                icon = 'fa fa-bolt';
                                break;
                        }

                        result.grid.data[i].status_node = new Element('span', {
                            'class': icon
                        });
                    }

                    self.$Grid.setData(result.grid);
                    resolve();
                }, {
                    'package': 'quiqqer/payment-transactions',
                    params: JSON.encode({
                        perPage: self.$Grid.options.perPage,
                        page: self.$Grid.options.page
                    }),
                    onError: reject
                });
            });
        },

        /**
         * Open the add dialog
         *
         * @param {String} txid
         */
        openTransaction: function (txid) {
            require([
                'package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction'
            ], function (Transaction) {
                new Transaction({
                    txid: txid
                }).open();
            });
        },

        /**
         * Open the add dialog
         */
        openAdd: function () {
            require([
                'package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd'
            ], (TransactionAdd) => {
                new TransactionAdd({
                    events: {
                        onSubmit: () => {
                            this.refresh();
                        }
                    }
                }).open();
            });
        },

        /**
         * Open the refund dialog
         *
         * @param {String} txid
         */
        openRefund: function (txid) {
            require([
                'package/quiqqer/payment-transactions/bin/backend/controls/refund/Window'
            ], function (RefundWindow) {
                new RefundWindow({
                    txid: txid
                }).open();
            });
        }
    });
});
