<?php

/**
 * This file contains package_quiqqer_payment-transactions_ajax_backend_add
 */

/**
 * Add a tx
 *
 * @param string|float $amount - JSON query params
 * @param string $payment - JSON query params
 * @return array
 */

use QUI\ERP\Defaults;

QUI::$Ajax->registerFunction(
    'package_quiqqer_payment-transactions_ajax_backend_add',
    function ($amount, $currency, $paymentId, $globalProcessId) {
        $payment = '';
        $amount = floatval($amount);

        if (empty($currency)) {
            $Currency = Defaults::getCurrency();
        } else {
            $Currency = QUI\ERP\Currency\Handler::getCurrency($currency);
        }

        if (!empty($paymentId)) {
            $Payment = QUI\ERP\Accounting\Payments\Payments::getInstance()->getPayment($paymentId);
            $payment = $Payment->getPaymentType()->getName();
        }

        $Transactions = new QUI\ERP\Accounting\Payments\Transactions\Factory();
        $Transactions->createPaymentTransaction(
            $amount,
            $Currency,
            false,
            $payment,
            [],
            null,
            false,
            $globalProcessId
        );
    },
    ['amount', 'currency', 'paymentId', 'globalProcessId'],
    'Permission::checkAdminUser'
);
