<?php

/**
 * This file contains package_quiqqer_payment-transactions_ajax_backend_getTransaction
 */

/**
 * Return the details of a specific transaction
 *
 * @param string $txId - Transaction ID
 * @return array
 */

QUI::$Ajax->registerFunction(
    'package_quiqqer_payment-transactions_ajax_backend_getTransaction',
    function ($txId) {
        $Handler = QUI\ERP\Accounting\Payments\Transactions\Handler::getInstance();

        try {
            $Transaction = $Handler->get($txId);
        } catch (Exception $exception) {
            $transactions = $Handler->getTransactionsByHash($txId);

            if (empty($transactions)) {
                throw $exception;
            }

            $Transaction = $transactions[0];
        }

        $Currency = $Transaction->getCurrency();
        $attributes = $Transaction->getAttributes();

        $attributes['amount_formatted'] = $Currency->format($attributes['amount']);
        $attributes['payment'] = $Transaction->getPayment()->toArray();

        return $attributes;
    },
    ['txId'],
    'Permission::checkAdminUser'
);
