/**
 * @module package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction
 * @author www.pcsg.de (Henning Leutz)
 */
define('package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction', [

    'qui/QUI',
    'qui/controls/windows/Popup',
    'package/quiqqer/payment-transactions/bin/backend/Transactions',
    'Mustache',
    'Locale',
    'Ajax',

    'text!package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction.html',
    'css!package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction.css'

], function (QUI, QUIPopup, Transactions, Mustache, QUILocale, QUIAjax, template) {
    "use strict";

    const lg = 'quiqqer/payment-transactions';

    return new Class({

        Extends: QUIPopup,
        Type   : 'package/quiqqer/payment-transactions/bin/backend/controls/windows/Transaction',

        Binds: [
            '$onOpen'
        ],

        options: {
            maxHeight: 700,
            maxWidth : 600,
            txid     : false,
            buttons  : false
        },

        /**
         * constructor
         *
         * @param {Options} options
         */
        initialize: function (options) {
            this.parent(options);

            this.setAttributes({
                icon : 'fa fa-money',
                title: ''
            });

            this.addEvents({
                onOpen: this.$onOpen
            });
        },

        /**
         * event: on open
         */
        $onOpen: function () {
            const Content = this.getContent();

            Content.set('html', '');
            Content.addClass('quiqqer-payment-transactions-window-transaction');

            this.Loader.show();

            Transactions.getTransaction(this.getAttribute('txid')).then((data) => {
                QUIAjax.get('package_quiqqer_erp_ajax_getProcessInformation', (process) => {
                    data.locale_title_general = QUILocale.get(lg, 'window.transaction.txid.title');
                    data.locale_title_tx = QUILocale.get(lg, 'window.transaction.tx.title');
                    data.locale_title_payment = QUILocale.get(lg, 'window.transaction.payment.title');

                    data.locale_txid = QUILocale.get(lg, 'txid');
                    data.locale_hash = QUILocale.get(lg, 'hash');
                    data.locale_date = QUILocale.get('quiqqer/system', 'date');
                    data.locale_amount = QUILocale.get(lg, 'window.transaction.amount');

                    data.locale_payment_id = QUILocale.get('quiqqer/system', 'id');
                    data.locale_payment_title = QUILocale.get('quiqqer/system', 'title');

                    data.titleProcessData = QUILocale.get(lg, 'quiqqer.refund.processData');
                    data.titleInvoice = QUILocale.get(lg, 'quiqqer.refund.titleInvoice');
                    data.titleOrder = QUILocale.get(lg, 'quiqqer.refund.titleOrder');
                    data.titleRefunds = QUILocale.get(lg, 'quiqqer.refund.titleRefunds');

                    Content.set({
                        html: Mustache.render(template, data)
                    });

                    this.$renderProcessData(process);
                    this.setAttribute('title', data.txid);
                    this.refresh();
                    this.Loader.hide();
                }, {
                    'package': 'quiqqer/erp',
                    hash     : data.hash
                });
            }).catch((err) => {
                console.error(err);
                this.close();
            });
        },

        $renderProcessData: function (process) {
            if (typeof process.invoice === 'undefined') {
                this.getElm().getElements('.information-invoice').destroy();
            } else {
                let invoiceId = '';

                if (typeof process.invoice.id_prefix !== 'undefined') {
                    invoiceId = invoiceId + process.invoice.id_prefix;
                }

                if (typeof process.invoice.id !== 'undefined') {
                    invoiceId = invoiceId + process.invoice.id;
                }

                this.getElm().getElement('.information-invoice-field').set({
                    html  : invoiceId,
                    events: {
                        click: () => {
                            // open the invoice panel
                            this.fireEvent('loadBegin');

                            require(['package/quiqqer/invoice/bin/backend/utils/Panels'], (Panels) => {
                                Panels.openInvoice(invoiceId).then(() => {
                                    this.fireEvent('loadEnd');
                                    this.fireEvent('openedPanel');
                                });
                            });
                        }
                    }
                });
            }

            if (typeof process.order === 'undefined' ||
                typeof process.order.temporary_invoice_id !== 'undefined') {
                this.getElm().getElements('.information-order').destroy();
            } else {
                this.getElm().getElement('.information-order-field').set({
                    'data-temp': 'orderId',
                    html       : process.order.id,
                    events     : {
                        click: () => {
                            // open the order panel
                            this.fireEvent('loadBegin');
                        }
                    }
                });
            }

            // transactions
            if (typeof process.transactions !== 'undefined' && process.transactions.length > 1) {
                const Refunds = this.getElm().getElement('.refunds');
                const List = new Element('ul');

                let i, len, p, currency;

                for (i = 0, len = process.transactions.length; i < len; i++) {
                    p = process.transactions[i];
                    currency = JSON.decode(p.currency);

                    new Element('li', {
                        html: p.txid + ' : ' + p.amount + ' ' + currency.sign
                    }).inject(List);
                }

                List.inject(Refunds.getElement('.information-refunds'));
            }

            // if payment data are empty
            const list = this.getElm().getElements('.information-refunds li');

            if (!list.length) {
                this.getElm().getElements('.information-refunds').set({
                    html: QUILocale.get(lg, 'message.process.data.empty')
                });
            }
        }
    });
});
