/**
 * @module package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd
 * @author www.pcsg.de (Henning Leutz)
 */
define('package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd', [

    'qui/QUI',
    'qui/controls/windows/Confirm',
    'package/quiqqer/payment-transactions/bin/backend/Transactions',
    'Mustache',
    'Locale',
    'Ajax',
    'Packages',

    'text!package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd.html',
    'css!package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd.css'

], function(QUI, QUIConfirm, Transactions, Mustache, QUILocale, QUIAjax, Packages, template) {
    'use strict';

    const lg = 'quiqqer/payment-transactions';

    return new Class({

        Extends: QUIConfirm,
        Type: 'package/quiqqer/payment-transactions/bin/backend/controls/windows/TransactionAdd',

        Binds: [
            '$onOpen'
        ],

        options: {
            maxHeight: 500,
            maxWidth: 600,
            autoclose: false
        },

        /**
         * constructor
         *
         * @param {Options} options
         */
        initialize: function(options) {
            this.parent(options);

            this.setAttributes({
                icon: 'fa fa-money',
                title: QUILocale.get(lg, 'erp.add.payment-transactions.title')
            });

            this.addEvents({
                onOpen: this.$onOpen
            });
        },

        /**
         * event: on open
         */
        $onOpen: function() {
            const Content = this.getContent();
            const current = QUILocale.getCurrent();

            Content.set('html', '');
            Content.addClass('quiqqer-payment-transactions-window-transaction');

            Content.set({
                html: Mustache.render(template, {
                    locale_title_general: QUILocale.get(lg, 'window.transaction.txid.title'),
                    locale_title_payment: QUILocale.get(lg, 'window.transaction.payment.title'),
                    locale_title_currency: QUILocale.get('quiqqer/currency', 'grid.setting.currency'),
                    locale_global_process_id: QUILocale.get('quiqqer/erp', 'global_process_id'),

                    locale_amount: QUILocale.get(lg, 'window.transaction.amount'),
                    locale_payment_title: QUILocale.get('quiqqer/core', 'title')
                })
            });

            Content.getElement('form').addEvent('submit', function(e) {
                e.stop();
            });

            this.Loader.show();

            QUI.parse(Content).then(function() {
                return Packages.isInstalled('quiqqer/payments');
            }).then((isInstalled) => {
                const PaymentSelect = Content.getElement('[name="payment"]');
                PaymentSelect.set('html', '');

                if (!isInstalled) {
                    this.Loader.hide();
                    return;
                }

                require(['package/quiqqer/payments/bin/backend/Payments'], (Payments) => {
                    Payments.getPayments().then((payments) => {
                        let i, len, title;

                        for (i = 0, len = payments.length; i < len; i++) {
                            title = '';

                            if (typeof payments[i].title[current] !== 'undefined') {
                                title = payments[i].title[current];
                            }

                            if (title === '') {
                                title = Object.keys(payments[i].title)[0];
                            }

                            new Element('option', {
                                value: payments[i].id,
                                html: title
                            }).inject(PaymentSelect);
                        }

                        const options = PaymentSelect.getElements('option');

                        options.sort(function(a, b) {
                            return a.get('html').localeCompare(b.get('html'));
                        });

                        options.each(function(option) {
                            option.inject(PaymentSelect);
                        });

                        this.Loader.hide();
                    });
                });
            });
        },

        submit: function() {
            const Form = this.getContent().getElement('form');

            let amount = Form.elements.amount.value;
            let currency = Form.elements.currency.value;
            let paymentId = Form.elements.payment.value;
            let global_process_id = Form.elements.global_process_id.value;

            if (amount === '') {
                Form.elements.amount.focus();

                if ('reportValidity' in Form.elements.amount) {
                    Form.elements.amount.reportValidity();
                }

                return;
            }

            this.Loader.show();

            QUIAjax.post('package_quiqqer_payment-transactions_ajax_backend_add', () => {
                this.fireEvent('submit');
                this.close();
            }, {
                'package': 'quiqqer/payment-transactions',
                amount: amount,
                currency: currency,
                paymentId: paymentId,
                globalProcessId: global_process_id,
                onError: (err) => {
                    console.error(err);
                    this.Loader.hide();
                }
            });
        }
    });
});
