<?php

/**
 * This file contains QUI\ERP\Accounting\Payments\Methods\Free\PaymentType
 */

namespace QUI\ERP\Accounting\Payments\Methods\Free;

use QUI;
use QUI\CRUD\Factory;
use QUI\ERP\Order\OrderInterface;
use QUI\Locale;

/**
 * Class PaymentType
 * - This class is a placeholder / helper class for the free payment
 * - if an order has no value of goods, this payment will be used
 */
class PaymentType extends QUI\ERP\Accounting\Payments\Types\Payment implements
    QUI\ERP\Accounting\Payments\Types\PaymentInterface
{
    public function __construct(protected int | string $id, protected Factory $Factory)
    {
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        $lg = 'quiqqer/payments';
        $Locale = QUI::getLocale();

        return [
            'id' => QUI\ERP\Accounting\Payments\Methods\Free\Payment::ID,
            'title' => $Locale->get($lg, 'payment.free.title'),
            'description' => $Locale->get($lg, 'payment.free.description'),
            'workingTitle' => $Locale->get($lg, 'payment.free.workingTitle'),
            'paymentType' => PaymentType::class,
            'payment_type' => PaymentType::class,
            'payment_code' => QUI\ERP\Accounting\Payments\Methods\Free\Payment::ID,
            'icon' => ''
        ];
    }

    /**
     * @param string $hash
     * @return bool
     */
    public function isSuccessful(string $hash): bool
    {
        return true;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return -1;
    }

    /**
     * Has the payment a payment fee?
     *
     * @return Bool
     */
    public function hasPaymentFee(): bool
    {
        return false;
    }

    /**
     * @param Locale|null $Locale
     * @return string
     */
    public function getTitle(null | QUI\Locale $Locale = null): string
    {
        $PaymentType = $this->getPaymentType();

        if ($Locale !== null) {
            $PaymentType->setLocale($Locale);
        }

        return $PaymentType->getTitle();
    }

    /**
     * @param Locale|null $Locale
     * @return string
     */
    public function getWorkingTitle(null | QUI\Locale $Locale = null): string
    {
        $PaymentType = $this->getPaymentType();

        if ($Locale !== null) {
            $PaymentType->setLocale($Locale);
        }

        return $PaymentType->getWorkingTitle();
    }

    /**
     * @param Locale|null $Locale
     * @return string
     */
    public function getDescription(null | QUI\Locale $Locale = null): string
    {
        $PaymentType = $this->getPaymentType();

        if ($Locale !== null) {
            $PaymentType->setLocale($Locale);
        }

        return $PaymentType->getDescription();
    }

    /**
     * @return string
     */
    public function getIcon(): string
    {
        return $this->getPaymentType()->getIcon();
    }

    /**
     * @return Payment
     */
    public function getPaymentType(): QUI\ERP\Accounting\Payments\Api\AbstractPayment
    {
        return new Payment();
    }

    /**
     * @param QUI\Interfaces\Users\User $User
     * @return bool
     */
    public function canUsedBy(QUI\Interfaces\Users\User $User): bool
    {
        return true;
    }

    /**
     * @param OrderInterface $Order
     * @return string
     */
    public function getOrderInformationText(QUI\ERP\Order\OrderInterface $Order): string
    {
        return '';
    }
}
