/**
 * @module package/quiqqer/productsearch/bin/controls/search/searchtypes/SelectMulti
 * @author www.pcsg.de (Henning Leutz)
 * @author www.pcsg.de (Patrick Müller)
 */
define('package/quiqqer/productsearch/bin/controls/search/searchtypes/SelectMulti', [

    'qui/QUI',
    'qui/controls/Control',
    'qui/controls/buttons/Select',

    'Locale'

], function (QUI, QUIControl, QUISelect, QUILocale) {
    "use strict";

    const lg = 'quiqqer/productsearch';

    return new Class({

        Extends: QUIControl,
        Type   : 'package/quiqqer/productsearch/bin/controls/search/searchtypes/SelectMulti',

        Binds: [
            '$onImport'
        ],

        initialize: function (options) {
            this.$Select = null;
            this.$Elm = null;
            this.$data = null;

            this.parent(options);
        },

        /**
         * Create the domnode element
         *
         * @return {HTMLDivElement}
         */
        create: function () {
            this.$Select = new QUISelect({
                showIcons            : false,
                placeholderSelectable: false,
                placeholderText      : QUILocale.get(lg, 'controls.search.searchTypes.SelectMulti.placeholder'),
                styles               : {
                    width: '100%'
                },
                multiple             : true,
                checkable            : true,
                events               : {
                    onChange: function () {
                        this.fireEvent('change', [this]);
                    }.bind(this)
                }
            });

            this.$Elm = this.$Select.create();
            this.$Elm.addClass('quiqqer-products-searchtype-selectmulti');

            this.refresh();

            return this.$Elm;
        },

        /**
         * Reset the field
         */
        reset: function () {
            this.refresh();
            this.fireEvent('change', [this]);
        },

        /**
         * Refresh the control
         */
        refresh: function () {
            if (!this.$Select || !this.$data) {
                return;
            }

            this.$Select.clear();
            this.$Select.selectPlaceholder();

            for (let i = 0, len = this.$data.length; i < len; i++) {
                this.$Select.appendChild(
                    this.$data[i].label,
                    this.$data[i].value
                );
            }
        },

        /**
         * Set the input select value
         * @param value
         */
        setSearchValue: function (value) {
            this.$Select.setValues(value);
        },

        /**
         * set the search data
         *
         * @param {object|array} data
         */
        setSearchData: function (data) {
            this.$data = data;
            this.refresh();
        },

        /**
         * Return the search value
         *
         * @returns {String|Boolean}
         */
        getSearchValue: function () {
            const selected = this.$Select.getValue();

            if (!selected.length) {
                return false;
            }

            return selected;
        }
    });
});
