/**
 * @module package/quiqqer/productsearch/bin/controls/search/searchtypes/CheckboxList
 * @author www.pcsg.de (Henning Leutz)
 */
define('package/quiqqer/productsearch/bin/controls/search/searchtypes/CheckboxList', [

    'qui/QUI',
    'qui/controls/Control',
    
    'css!package/quiqqer/productsearch/bin/controls/search/searchtypes/CheckboxList.css'

], function (QUI, QUIControl) {
    "use strict";

    function renameNode(node, newNodeName) {
        const newNode = node.ownerDocument.createElement(newNodeName);
        Array.from(node.attributes).forEach(attr => newNode.setAttribute(attr.localName, attr.value));
        Array.from(node.childNodes).forEach(childNode => newNode.appendChild(childNode));

        node.parentElement.insertBefore(newNode, node);
        node.parentElement.removeChild(node);
    }

    return new Class({

        Extends: QUIControl,
        Type   : 'package/quiqqer/productsearch/bin/controls/search/searchtypes/CheckboxList',

        Binds: [
            '$onInject'
        ],

        initialize: function (options) {
            this.$Elm = null;
            this.$data = null;

            this.parent(options);

            this.addEvents({
                onImport: this.$onImport,
                onInject: this.$onInject
            });
        },

        $onInject: function () {
            const FilterParent = this.getElm().getParent('.quiqqer-products-productList-filter-entry');

            if (FilterParent && FilterParent.nodeName === 'LABEL') {
                renameNode(FilterParent, 'div');
            }
        },

        /**
         * Create the domnode element
         *
         * @return {HTMLDivElement}
         */
        create: function () {
            this.$Elm = this.parent();
            this.$Elm.addClass('quiqqer-products-searchtype-checkboxList');

            this.refresh();

            return this.$Elm;
        },

        /**
         * Reset the field
         */
        reset: function () {
            this.refresh();
            this.fireEvent('change', [this]);
        },

        /**
         * Refresh the control
         */
        refresh: function () {
            if (!this.$data) {
                return;
            }

            this.$Elm.set('html', '');

            let i, len, label, value;

            for (i = 0, len = this.$data.length; i < len; i++) {
                label = this.$data[i].label;
                value = this.$data[i].value;

                new Element('label', {
                    'class': 'qui-control quiqqer-products-searchtype-checkboxList-label',
                    'html' : '<input type="checkbox" value="' + value + '" />' +
                             '<span class="quiqqer-products-searchtype-checkboxList-label-title">' + label + '</span>'
                }).inject(this.$Elm);
            }

            this.$Elm.getElements('input[type="checkbox"]').addEvent('change', () => {
                this.fireEvent('change', [this]);
            });
        },

        /**
         * Set the input select value
         * @param value
         */
        setSearchValue: function (value) {
            for (let i = 0, len = value.length; i < len; i++) {
                this.$Elm.getElements('input[value="' + value[i] + '"]').set('checked', true);
            }
        },

        /**
         * set the search data
         *
         * @param {object|array} data
         */
        setSearchData: function (data) {
            this.$data = data;
            this.refresh();
        },

        /**
         * Return the search value
         *
         * @returns {String|Boolean}
         */
        getSearchValue: function () {
            let checked = this.$Elm.getElements('input[type="checkbox"]:checked');

            if (!checked.length) {
                return false;
            }

            return checked.map(function (Checkbox) {
                return Checkbox.value;
            });
        }
    });
});
