![QUIQQER Product Searcg](bin/images/Readme.jpg)

QUIQQER Product Search
========

This package provides the Search API for quiqqer/products.

Package name:

    quiqqer/productsearch

Features
--------

- Search products in frontend and backend

Configuration
---

### Frontend field weights

The frontend search free-text ranking can be configured via the package config section `frontend_field_weights`.

`FrontendSearch::search()` uses these weights only when products are searched via free text input by the user (i.e. via the search input field).  
For every configured field, it calculates a score and then sorts by the summed score (`ORDER BY score DESC`).

Score per field:

`(MATCH(field) AGAINST (:searchTerm IN BOOLEAN MODE) * priority) + extraFieldWeights - (LENGTH(field) * lengthModifier)`

Then all field scores are added to one final `score`.

Required structure per field:

- `priority` (number): main relevance multiplier for `MATCH ... AGAINST`.
- `lengthModifier` (number): penalty for longer field values.
- `extraFieldWeights` (object): optional additive weights for other numeric columns.

Default weights are created on package setup (if the section is empty) for:

- `productNo`
- product title field column (`F<fieldId>`)
- short description field column (`F<fieldId>`)

Example (PHP):

```php
$Conf = QUI::getPackage('quiqqer/productsearch')->getConfig();

$Conf->setSection('frontend_field_weights', [
    'productNo' => json_encode([
        'priority' => 1000,
        'lengthModifier' => 100,
        'extraFieldWeights' => []
    ]),
    'F2' => json_encode([ // example field column name
        'priority' => 100,
        'lengthModifier' => 1,
        'extraFieldWeights' => [
            'priority' => 0.5
        ]
    ])
]);

$Conf->save();
```

Notes:

- Keys in `frontend_field_weights` must match real column names in the products cache table.
- For very short search terms (`< 4` chars), an additional internal fallback score is added by `search()` (exact and `LIKE` matches), because MySQL fulltext matching is limited for short terms.

Installation
------------

The package name: quiqqer/productsearch

Contribution
----------

- Issue Tracker: https://dev.quiqqer.com/quiqqer/productsearch/issues
- Source Code: https://dev.quiqqer.com/quiqqer/productsearch/tree/master

Support
-------

If you have found a bug, or want improvements,
then you are welcome to send an e-mail to support@pcsg.de

License
-------

GPL-3.0+
