/**
 * @module package/quiqqer/productsearch/bin/controls/products/search/Window
 * @author www.pcsg.de (Henning Leutz)
 */
define('package/quiqqer/productsearch/bin/controls/products/search/Window', [

    'qui/QUI',
    'qui/controls/Control',
    'qui/controls/buttons/Button',
    'qui/controls/windows/Confirm',
    'package/quiqqer/productsearch/bin/controls/products/search/Search',
    'Locale',

    'css!package/quiqqer/productsearch/bin/controls/products/search/Window.css'

], function (QUI, QUIControl, QUIButton, QUIConfirm, Search, QUILocale) {
    "use strict";

    return new Class({

        Extends: QUIConfirm,
        Type   : 'package/quiqqer/productsearch/bin/controls/products/search/Window',

        Binds: [
            'search',
            'submit',
            '$onOpen',
            '$onOpenBegin',
            '$onResize',
            '$onSearch',
            '$onSearchBegin',
            'tableRefresh'
        ],

        options: {
            maxHeight   : 600,
            maxWidth    : 800,
            icon        : 'fa fa-search',
            title       : 'Produktsuche', // #locale
            autoclose   : true,
            multiple    : false,
            productTypes: []
        },

        initialize: function (options) {
            this.parent(options);

            this.$Search = null;

            this.addEvents({
                onOpen     : this.$onOpen,
                onOpenBegin: this.$onOpenBegin,
                onResize   : this.$onResize,
            });
        },

        /**
         * event : on resize
         *
         * @return {Promise}
         */
        $onResize: function () {
            if (this.$Search) {
                this.$Search.resize();
            }
        },

        /**
         * event: on open begin
         */
        $onOpenBegin: function () {
            var size = document.body.getSize();

            var width = size.x - 100;
            var height = size.y - 100;

            if (width > 1400) {
                width = 1400;
            }

            if (height > 1200) {
                height = 1200;
            }

            this.setAttribute('maxWidth', width);
            this.setAttribute('maxHeight', height);
        },

        /**
         * Return the DOMNode Element
         *
         * @returns {HTMLDivElement}
         */
        $onOpen: function (Win) {
            var self    = this,
                Content = Win.getContent();

            this.setAttribute('maxWidth', 1400);

            Content.set('html', '');
            Content.addClass('quiqqer-productSearch-window-content');

            var ButtonsContainer = new Element('div', {
                'class': 'quiqqer-productSearch-window-buttons',
                'html' : '' +
                         '<form>' +
                         '   <input type="search" />' +
                         '   <button class="qui-button qui-utils-noselect">' +
                         '       <span class="fa fa-search"></span>' +
                         '   </button>' +
                         '</form>'
            }).inject(Content);

            ButtonsContainer.getElement('form').setStyles({
                'float': 'right'
            });

            ButtonsContainer.getElement('input').set(
                'placeholder',
                QUILocale.get('quiqqer/products', 'controls.products.search')
            );

            this.$SearchInput = ButtonsContainer.getElement('input');

            var SearchContainer = new Element('div', {
                'class': 'quiqqer-productSearch-window-content-search',
                'html' : '<div></div>'
            }).inject(Content);

            this.$Search = new Search({
                productTypes: this.getAttribute('productTypes'),
                searchbutton: false,
                events      : {
                    onDblClick: function () {
                        self.submit();
                    },

                    onSearchBegin: function () {
                        self.Loader.show();
                    },

                    onSearch: function () {
                        self.Loader.hide();
                        self.fireEvent('load', [self]);
                    }
                }
            }).inject(SearchContainer.getElement('div'));

            (() => {
                this.$Search.resize();
            }).delay(600);

            this.$Search.resize();
            this.$Search.search();

            ButtonsContainer.getElement('form').addEvent('submit', function (e) {
                e.stop();
                self.getContent().getElements('[name="search"]').set('value', self.$SearchInput.value);
                self.$Search.search();
            });
        },

        /**
         * Execute the search
         */
        search: function () {
            this.$Search.search();
        },

        /**
         * Submit
         *
         * @fires onSubmit
         */
        submit: function () {
            var selected = this.$Search.getSelected();

            if (!selected.length) {
                return;
            }

            this.fireEvent('submit', [
                this,
                selected
            ]);

            if (this.getAttribute('autoclose')) {
                this.close();
            }
        }
    });
});
