<?php

/**
 * This file contains the login site type
 *
 * @var QUI\Projects\Project $Project
 * @var QUI\Projects\Site $Site
 * @var QUI\Interfaces\Template\EngineInterface $Engine
 * @var QUI\Template $Template
 **/

use QUI\ERP\Products\Controls\Category\ProductList;
use QUI\ERP\Products\Search\Utils as SearchUtils;

if (!empty($_GET)) {
    $Engine->getCanonical()->considerGetParameterOn();
}

$ProductList = new ProductList([
    'categoryId' => $Site->getAttribute('quiqqer.products.settings.categoryId'),
    'autoload' => false,
    'searchParams' => SearchUtils::getSearchParameterFromRequest(),
    'view' => SearchUtils::getViewParameterFromRequest(),
    'productLoadNumber' => $Site->getAttribute('quiqqer.products.settings.productLoadNumber'),
    'autoloadAfter' => $Site->getAttribute('quiqqer.products.settings.autoloadAfter')
]);

if ($Site->getAttribute('quiqqer.products.settings.showFilterLeft')) {
    $ProductList->setAttribute('showFilter', false);
}

$ProductList->addSort(
    QUI::getLocale()->get('quiqqer/products', 'sort.cdate.ASC'),
    'c_date ASC'
);

$ProductList->addSort(
    QUI::getLocale()->get('quiqqer/products', 'sort.cdate.DESC'),
    'c_date DESC'
);

$Engine->assign([
    'ProductList' => $ProductList
]);
