/**
 *
 * Yes / No Field
 * Ein Ja / Nein Feld
 *
 * @event onChange
 */
define('package/quiqqer/productsearch/bin/controls/search/searchtypes/Checkbox', [

    'qui/QUI',
    'qui/controls/Control',
    'qui/controls/buttons/Select',
    'Locale'

], function (QUI, QUIControl, QUISelect, QUILocale) {
    "use strict";

    return new Class({

        Extends: QUIControl,
        Type: 'package/quiqqer/productsearch/bin/controls/search/searchtypes/Checkbox',

        Binds: [
            '$onImport',
            '$onInject'
        ],

        initialize: function (options) {
            this.$Elm = null;
            this.$Input = null;

            this.parent(options);

            this.addEvents({
                onImport: this.$onImport,
                onInject: this.$onInject
            });
        },

        $onImport: function () {
            console.log('import');
        },

        $onInject: function () {
            let FieldEntry = this.getElm().getParent('.quiqqer-products-productList-filter-entry');
            let FieldTitle;

            if (!FieldEntry) {
                // backend
                FieldEntry = this.getElm().getParent('.quiqqer-products-search-field-container');

                if (!FieldEntry) {
                    return;
                }

                FieldTitle = FieldEntry.getElement('.quiqqer-products-search-field-label');
                FieldTitle.setStyle('width', 'initial');
            } else {
                // frontendf
                FieldTitle = FieldEntry.getElement('.quiqqer-products-productList-filter-entry-title');
            }

            const Container = new Element('div', {
                'class': 'quiqqer-products-searchtype-checkbox'
            }).wraps(FieldTitle);

            this.$Input = new Element('input', {
                type: 'checkbox',
                value: '',
                events: {
                    change: () => {
                        this.fireEvent('change', [this]);
                    }
                }
            }).inject(Container, 'top');

            if (FieldTitle.hasClass('quiqqer-products-search-field-label')) {
                this.$Input.setStyle('float', 'left');
            }

            this.$Elm.destroy();
            this.$Elm = Container;
        },

        /**
         * Reset the field
         */
        reset: function () {
            this.$Input.set('checked', false);
        },

        /**
         * set the search data
         *
         * @param {object|array} data
         */
        setSearchData: function (data) {
        },

        /**
         * Set the input select value
         * @param value
         */
        setSearchValue: function (value) {
            this.setAttribute('value', value);
        },

        /**
         * Return the search value
         *
         * @returns {String|Boolean}
         */
        getSearchValue: function () {
            return this.$Input.checked ? 1 : '';
        },

        /**
         * Return the search value formatted (yes or empty)
         *
         * @return {String}
         */
        getSearchValueFormatted: function () {
            if (this.$Input.checked) {
                return QUILocale.get('quiqqer/system', 'yes');
            }

            return '';
        }
    });
});
