<?php

/**
 * Cancel/abort single job
 *
 * @return bool - success
 */

use QUI\QueueManager\QueueJobUUID;
use QUI\QueueManager\QueueManager;
use QUI\Utils\Security\Orthos;

QUI::$Ajax->registerFunction(
    'package_quiqqer_queuemanager_ajax_deleteJob',
    function ($jobId) {
        try {
            $qm = new QueueManager();
            $qm->getCurrentQueueServer()->deleteJob(new QueueJobUUID(Orthos::clear($jobId)));
        } catch (\Exception $Exception) {
            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/queuemanager',
                    'error.job.cancel.error',
                    [
                        'error' => $Exception->getMessage()
                    ]
                )
            );

            return false;
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/queuemanager',
                'success.job.cancel',
                [
                    'jobId' => $jobId
                ]
            )
        );

        return true;
    },
    ['jobId'],
    'Permission::checkAdminUser'
);
