<?php

namespace QUI\QueueManager\Interfaces;

use QUI\QueueManager\QueueJob;
use QUI\QueueManager\QueueJobUUID;
use QUI\QueueManager\QuiqqerWorkerQueueJob;

interface QueueJobRepositoryInterface
{
    /**
     * @param QueueJob $job
     * @return QueueJob - Inserted QueueJob with UUID
     */
    public function insert(QueueJob $job): QueueJob;

    /**
     * @param QueueJob $job
     * @return void
     */
    public function update(QueueJob $job): void;

    /**
     * @param QueueJobUUID $jobId
     * @return void
     */
    public function delete(QueueJobUUID $jobId): void;

    /**
     * @param QueueJobUUID $jobId
     * @return QueueJob|QuiqqerWorkerQueueJob|null
     */
    public function find(QueueJobUUID $jobId): QueueJob|QuiqqerWorkerQueueJob|null;

    /**
     * @param array $where (optional) - WHERE clause (QUIQQER DB syntax)
     * @return QueueJob[]
     */
    public function findAll(array $where = []): array;
}
