<?php

namespace QUI\QueueManager\Interfaces;

use QUI\QueueManager\QueueJobAttributes;
use QUI\QueueManager\QuiqqerWorkerQueueJob;

interface QuiqqerWorkerQueueJobFactoryInterface
{
    /**
     * Create a new Quiqqer Worker Queue Job and immediately schedule it.
     *
     * @param class-string<QuiqqerQueueWorkerInterface> $workerClass
     * @param array|null $jobData
     * @param array|QueueJobAttributes|null $jobAttributes
     * @return QuiqqerWorkerQueueJob
     */
    public function createAndSchedule(
        string $workerClass,
        ?array $jobData = null,
        array | QueueJobAttributes | null $jobAttributes = null
    ): QuiqqerWorkerQueueJob;

    /**
     * Create a new Quiqqer Worker Queue Job.
     *
     * @param class-string<QuiqqerQueueWorkerInterface> $workerClass
     * @param array|null $jobData
     * @param array|QueueJobAttributes|null $jobAttributes
     * @return QuiqqerWorkerQueueJob
     */
    public function create(
        string $workerClass,
        ?array $jobData = null,
        array | QueueJobAttributes | null $jobAttributes = null
    ): QuiqqerWorkerQueueJob;
}
