<?php

namespace QUI\QueueManager;

use function array_key_exists;

class JobData
{
    /**
     * @param string|array<string|int,mixed>|null $data
     */
    public function __construct(private array|string|null $data = null)
    {
    }

    /**
     * @param string|array<string|int,mixed> $value
     * @return void
     */
    public function set(string $key, string|array $value): void
    {
        $this->data[$key] = $value;
    }

    public function get(string $key): string|array|null
    {
        if (!array_key_exists($key, $this->data)) {
            return null;
        }

        return $this->data[$key];
    }

    /**
     * @param string|array<string|int,mixed>|null $data
     * @return void
     */
    public function setAll(string|array|null $data): void
    {
        $this->data = $data;
    }

    /**
     * @return  string|array<string|int,mixed>|null $data
     */
    public function getAll(): array|string|null
    {
        return $this->data;
    }

    public function jsonSerialize(): string
    {
        if (is_string($this->data)) {
            return $this->data;
        }

        return json_encode($this->data);
    }
}
