<?php

namespace QUI\QueueManager;

use DateTime;
use InvalidArgumentException;
use QUI\QueueManager\Interfaces\QuiqqerQueueWorkerInterface;

use function is_a;
use function is_null;

/**
 * Job to be put in the queue.
 */
class QueueJob
{
    public JobStatus $status = JobStatus::QUEUED;

    public readonly JobData $data;
    public ?JobData $result = null;
    public readonly QueueJobAttributes $jobAttributes;
    public readonly JobLog $log;

    /**
     * @param QueueJobUUID|null $uuid (optional) - Is created on INSERT
     * @param QueueJobAttributes|null $jobAttributes (optional) - If omitted, initializes with default attributes
     */
    public function __construct(
        public readonly ?QueueJobUUID $uuid = null,
        ?QueueJobAttributes $jobAttributes = null,
        public ?DateTime $createDate = null,
        public ?DateTime $updateDate = null,
        public readonly bool $isQuiqqerWorkerJob = false
    ) {
        $this->data = new JobData();
        $this->log = new JobLog();

        if (is_null($jobAttributes)) {
            $this->jobAttributes = new QueueJobAttributes();
        } else {
            $this->jobAttributes = $jobAttributes;
        }

        if (is_null($this->createDate)) {
            $this->createDate = new DateTime();
        }

        if (is_null($this->updateDate)) {
            $this->updateDate = new DateTime();
        }
    }

    /**
     * Get the date this job should be queued at the earliest.
     *
     * @return \DateTime|null
     */
    public function getEarliestQueueDate(): ?\DateTime
    {
        return $this->jobAttributes->earliestQueueDate;
    }
}
