<?php

/**
 * Cancel/abort single job
 *
 * @return bool - success
 */

use QUI\QueueManager\QueueJobUUID;
use QUI\QueueManager\QueueManager;
use QUI\Utils\Security\Orthos;

QUI::$Ajax->registerFunction(
    'package_quiqqer_queuemanager_ajax_repeatJob',
    function ($jobId) {
        try {
            $qm = new QueueManager();
            $qm->getCurrentQueueServer()->cloneJob(new QueueJobUUID(Orthos::clear($jobId)), 1);
        } catch (\Exception $Exception) {
            QUI\System\Log::writeException($Exception);

            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/queuemanager',
                    'error.job.repeat.error',
                    [
                        'error' => $Exception->getMessage()
                    ]
                )
            );

            return false;
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/queuemanager',
                'success.job.repeat',
                [
                    'jobId' => $jobId
                ]
            )
        );

        return true;
    },
    ['jobId'],
    'Permission::checkAdminUser'
);
