<?php

namespace QUI\QueueManager\Interfaces;

use QUI\Locale;

/**
 * Must be implemented by "queueServer" QUIQQER providers.
 */
interface QueueServerProviderInterface
{
    /**
     * Get instance of a queue server.
     *
     * @return QueueServerInterface
     */
    public function getQueueServer(): QueueServerInterface;

    /**
     * Get fully qualified class name of the provided queue server.
     *
     * @return string
     */
    public function getQueueServerClass(): string;

    /**
     * Title of the provided queue server.
     *
     * @param Locale|null $locale
     * @return string
     */
    public function getTitle(?Locale $locale = null): string;

    /**
     * Description of the provided queue server.
     *
     * @param Locale|null $locale
     * @return string
     */
    public function getDescription(?Locale $locale = null): string;
}
