<?php

namespace QUI\QueueManager;

use function mb_strlen;

readonly class QueueJobUUID
{
    public function __construct(public string $uuid)
    {
        if (mb_strlen($this->uuid) !== 36) {
            throw new \InvalidArgumentException('UUID must be 36 characters long');
        }
    }

    public function __toString(): string
    {
        return $this->uuid;
    }
}
