<?php

namespace QUI\QueueManager\Repository;

use QUI\QueueManager\Interfaces\QuiqqerWorkerQueueJobFactoryInterface;
use QUI\QueueManager\Interfaces\QuiqqerWorkerQueueJobSchedulerServiceInterface;
use QUI\QueueManager\QueueJobAttributes;
use QUI\QueueManager\QuiqqerWorkerQueueJob;
use QUI\QueueManager\Service\QuiqqerWorkerQueueJobSchedulerService;

use function is_array;
use function property_exists;

class QuiqqerWorkerQueueJobFactory implements QuiqqerWorkerQueueJobFactoryInterface
{
    public function __construct(
        private ?QuiqqerWorkerQueueJobSchedulerServiceInterface $scheduler = null
    ) {
        if (is_null($this->scheduler)) {
            $this->scheduler = new QuiqqerWorkerQueueJobSchedulerService();
        }
    }

    /**
     * @inheritDoc
     */
    public function createAndSchedule(
        string $workerClass,
        ?array $jobData = null,
        array | QueueJobAttributes | null $jobAttributes = null
    ): QuiqqerWorkerQueueJob {
        $job = $this->create($workerClass, $jobData, $jobAttributes);
        $this->scheduler->schedule($job);
        return $job;
    }

    /**
     * @inheritDoc
     */
    public function create(
        string $workerClass,
        ?array $jobData = null,
        array | QueueJobAttributes | null $jobAttributes = null
    ): QuiqqerWorkerQueueJob {
        if (is_array($jobAttributes)) {
            $data = $jobAttributes;
            $jobAttributes = new QueueJobAttributes();

            foreach ($data as $k => $v) {
                if (property_exists($workerClass, $k)) {
                    $jobAttributes->$k = $v;
                }
            }
        }
        return new QuiqqerWorkerQueueJob($workerClass, null, $jobAttributes, $jobData);
    }
}
