<?php

/**
 * Get list of queue server jobs
 *
 * @return array
 */

use QUI\QueueManager\QueueJobUUID;
use QUI\Utils\Security\Orthos;
use QUI\QueueManager\Repository\QueueJobRepository;

QUI::$Ajax->registerFunction(
    'package_quiqqer_queuemanager_ajax_getJobDetails',
    function ($jobId) {
        $jobId = new QueueJobUUID(Orthos::clear($jobId));
        $repository = new QueueJobRepository();
        $job = $repository->find($jobId);
        $locale = QUI::getLocale();

        $details['jobData'] = $job->data->getAll();
        $details['resultData'] = $job->result?->getAll();

        $details['createTime'] = $job->createDate ?
            $locale->formatDate($job->createDate->getTimestamp()) :
            '-';

        $details['lastUpdateTime'] = $job->updateDate ?
            $locale->formatDate($job->updateDate->getTimestamp()) :
            '-';

        $details['jobLog'] = $job->log->logEntries;

        return $details;
    },
    ['jobId'],
    'Permission::checkAdminUser'
);
