<?php

namespace QUI\QueueManager\Examples;

use QUI\QueueManager\AbstractQuiqqerQueueWorker;
use QUI\QueueManager\JobData;
use QUI\QueueManager\QuiqqerWorkerQueueJob;

/**
 * Class ExampleWorker
 *
 * Example worker that reverses a string
 *
 * @package quiqqer/queuemanager
 */
class ExampleWorker extends AbstractQuiqqerQueueWorker
{
    /**
     * Execute job
     *
     * @return JobData
     */
    public function execute(QuiqqerWorkerQueueJob $job): JobData
    {
        parent::execute($job);

        $string = $this->job->data->get('string');
        $this->writeLogEntry('String came in: ' . $string);

        $string = strrev($string);
        $this->writeLogEntry('String reversed.');

        $result = new JobData();
        $result->set('stringReversed', $string);

        return $result;
    }
}
