<?php

namespace QUI\QueueManager;

use InvalidArgumentException;
use QUI\QueueManager\Interfaces\QuiqqerQueueWorkerInterface;

use function is_a;

/**
 * Queue job specifically intended for a QUIQQER task worker.
 */
class QuiqqerWorkerQueueJob extends QueueJob
{
    /**
     * @param class-string<QuiqqerQueueWorkerInterface> $workerClass
     * @param QueueJobUUID|null $uuid
     * @param QueueJobAttributes|null $jobAttributes
     * @param array|null $jobData
     */
    public function __construct(
        string $workerClass,
        ?QueueJobUUID $uuid = null,
        QueueJobAttributes | null $jobAttributes = null,
        ?array $jobData = null
    ) {
        // @phpstan-ignore function.alreadyNarrowedType (PHPDoc class-string is not enforcing)
        if (!is_a($workerClass, QuiqqerQueueWorkerInterface::class, true)) {
            throw new InvalidArgumentException(
                "Class '$workerClass' does not implement " . QuiqqerQueueWorkerInterface::class
            );
        }

        parent::__construct(
            uuid: $uuid,
            jobAttributes: $jobAttributes,
            isQuiqqerWorkerJob: true
        );

        if (!is_null($jobData)) {
            $this->data->setAll($jobData);
        }

        $this->data->set('workerClass', $workerClass);
    }

    public function getQuiqqerQueueWorkerClass(): ?string
    {
        return $this->data->get('workerClass');
    }
}
