<?php

namespace QUI\QueueManager\Service;

use QUI\QueueManager\Interfaces\QueueServerInterface;
use QUI\QueueManager\Interfaces\QuiqqerWorkerQueueJobSchedulerServiceInterface;
use QUI\QueueManager\QueueManager;
use QUI\QueueManager\QuiqqerWorkerQueueJob;

class QuiqqerWorkerQueueJobSchedulerService implements QuiqqerWorkerQueueJobSchedulerServiceInterface
{
    private QueueServerInterface $queueServer;

    /**
     * @throws \QUI\Exception
     */
    public function __construct()
    {
        $queueManager = new QueueManager();
        $this->queueServer = $queueManager->getCurrentQueueServer();
    }

    /**
     * Schedule a quiqqer worker queue job.
     *
     * @param QuiqqerWorkerQueueJob $job
     * @return void
     */
    public function schedule(QuiqqerWorkerQueueJob $job): void
    {
        $this->queueServer->queueJob($job);
    }
}
