<?php

/**
 * Cancel/abort single job
 *
 * @return bool - success
 */

QUI::$Ajax->registerFunction(
    'package_quiqqer_queueserver_ajax_repeatJob',
    function ($jobId) {
        try {
            \QUI\QueueManager\QueueManager::cloneJob((int)$jobId, 1);
        } catch (\Exception $Exception) {
            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/queueserver',
                    'error.job.repeat.error',
                    [
                        'error' => $Exception->getMessage()
                    ]
                )
            );

            return false;
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/queueserver',
                'success.job.repeat',
                [
                    'jobId' => $jobId
                ]
            )
        );

        return true;
    },
    ['jobId'],
    'Permission::checkAdminUser'
);
