<?php

namespace QUI\QueueServer;

use QUI;

/**
 * Quiqqer queue server cronjob for repeatedly fetching and executing queue jobs
 */
class Cron
{
    /**
     * Execute all jobs in queue
     * @return void
     */
    public static function execute(): void
    {
        $server = new Server();

        do {
            try {
                $jobExecuted = $server->executeNextJob();
            } catch (\Exception $exception) {
                QUI\System\Log::writeException($exception);
                break;
            }
        } while ($jobExecuted === true);
    }

    /**
     * Clean all jobs older than X days.
     */
    public static function cleanJobs(array $params): void
    {
        try {
            $server = new Server();
            $server->cleanJobs($params['days']);
        } catch (\Exception $exception) {
            QUI\System\Log::writeException($exception);
        }
    }
}
