<?php

namespace QUI\QueueServer;

use QUI;
use QUI\Locale;
use QUI\QueueManager\Interfaces\QueueServerProviderInterface;

use function is_null;

class Provider implements QueueServerProviderInterface
{
    public function getTitle(?Locale $locale = null): string
    {
        if (is_null($locale)) {
            $locale = QUI::getLocale();
        }

        return $locale->get('quiqqer/queueserver', 'server.title');
    }

    public function getDescription(?Locale $locale = null): string
    {
        if (is_null($locale)) {
            $locale = QUI::getLocale();
        }

        return $locale->get('quiqqer/queueserver', 'server.description');
    }

    /**
     * @return Server
     */
    public function getQueueServer(): Server
    {
        return new Server();
    }

    public function getQueueServerClass(): string
    {
        return Server::class;
    }
}
