/**
 * Promise https://github.com/then/promise
 * Version 7.0.1
 */
(function e(t, n, r) {
    function s(o, u) {
        if (!n[o]) {
            if (!t[o]) {
                var a = typeof require == "function" && require;
                if (!u && a) return a(o, !0);
                if (i) return i(o, !0);
                var f = new Error("Cannot find module '" + o + "'");
                throw f.code = "MODULE_NOT_FOUND", f;
            }
            var l = n[o] = {
                exports: {}
            };
            t[o][0].call(l.exports, function(e) {
                var n = t[o][1][e];
                return s(n ? n : e);
            }, l, l.exports, e, t, n, r);
        }
        return n[o].exports;
    }
    var i = typeof require == "function" && require;
    for (var o = 0; o < r.length; o++) s(r[o]);
    return s;
})({
    1: [ function(require, module, exports) {
        module.exports = function() {
            var events = require("events");
            var domain = {};
            domain.createDomain = domain.create = function() {
                var d = new events.EventEmitter();
                function emitError(e) {
                    d.emit("error", e);
                }
                d.add = function(emitter) {
                    emitter.on("error", emitError);
                };
                d.remove = function(emitter) {
                    emitter.removeListener("error", emitError);
                };
                d.bind = function(fn) {
                    return function() {
                        var args = Array.prototype.slice.call(arguments);
                        try {
                            fn.apply(null, args);
                        } catch (err) {
                            emitError(err);
                        }
                    };
                };
                d.intercept = function(fn) {
                    return function(err) {
                        if (err) {
                            emitError(err);
                        } else {
                            var args = Array.prototype.slice.call(arguments, 1);
                            try {
                                fn.apply(null, args);
                            } catch (err) {
                                emitError(err);
                            }
                        }
                    };
                };
                d.run = function(fn) {
                    try {
                        fn();
                    } catch (err) {
                        emitError(err);
                    }
                    return this;
                };
                d.dispose = function() {
                    this.removeAllListeners();
                    return this;
                };
                d.enter = d.exit = function() {
                    return this;
                };
                return d;
            };
            return domain;
        }.call(this);
    }, {
             events: 2
         } ],
    2: [ function(require, module, exports) {
        function EventEmitter() {
            this._events = this._events || {};
            this._maxListeners = this._maxListeners || undefined;
        }
        module.exports = EventEmitter;
        EventEmitter.EventEmitter = EventEmitter;
        EventEmitter.prototype._events = undefined;
        EventEmitter.prototype._maxListeners = undefined;
        EventEmitter.defaultMaxListeners = 10;
        EventEmitter.prototype.setMaxListeners = function(n) {
            if (!isNumber(n) || n < 0 || isNaN(n)) throw TypeError("n must be a positive number");
            this._maxListeners = n;
            return this;
        };
        EventEmitter.prototype.emit = function(type) {
            var er, handler, len, args, i, listeners;
            if (!this._events) this._events = {};
            if (type === "error") {
                if (!this._events.error || isObject(this._events.error) && !this._events.error.length) {
                    er = arguments[1];
                    if (er instanceof Error) {
                        throw er;
                    }
                    throw TypeError('Uncaught, unspecified "error" event.');
                }
            }
            handler = this._events[type];
            if (isUndefined(handler)) return false;
            if (isFunction(handler)) {
                switch (arguments.length) {
                    case 1:
                        handler.call(this);
                        break;

                    case 2:
                        handler.call(this, arguments[1]);
                        break;

                    case 3:
                        handler.call(this, arguments[1], arguments[2]);
                        break;

                    default:
                        len = arguments.length;
                        args = new Array(len - 1);
                        for (i = 1; i < len; i++) args[i - 1] = arguments[i];
                        handler.apply(this, args);
                }
            } else if (isObject(handler)) {
                len = arguments.length;
                args = new Array(len - 1);
                for (i = 1; i < len; i++) args[i - 1] = arguments[i];
                listeners = handler.slice();
                len = listeners.length;
                for (i = 0; i < len; i++) listeners[i].apply(this, args);
            }
            return true;
        };
        EventEmitter.prototype.addListener = function(type, listener) {
            var m;
            if (!isFunction(listener)) throw TypeError("listener must be a function");
            if (!this._events) this._events = {};
            if (this._events.newListener) this.emit("newListener", type, isFunction(listener.listener) ? listener.listener : listener);
            if (!this._events[type]) this._events[type] = listener; else if (isObject(this._events[type])) this._events[type].push(listener); else this._events[type] = [ this._events[type], listener ];
            if (isObject(this._events[type]) && !this._events[type].warned) {
                var m;
                if (!isUndefined(this._maxListeners)) {
                    m = this._maxListeners;
                } else {
                    m = EventEmitter.defaultMaxListeners;
                }
                if (m && m > 0 && this._events[type].length > m) {
                    this._events[type].warned = true;
                    console.error("(node) warning: possible EventEmitter memory " + "leak detected. %d listeners added. " + "Use emitter.setMaxListeners() to increase limit.", this._events[type].length);
                    if (typeof console.trace === "function") {
                        console.trace();
                    }
                }
            }
            return this;
        };
        EventEmitter.prototype.on = EventEmitter.prototype.addListener;
        EventEmitter.prototype.once = function(type, listener) {
            if (!isFunction(listener)) throw TypeError("listener must be a function");
            var fired = false;
            function g() {
                this.removeListener(type, g);
                if (!fired) {
                    fired = true;
                    listener.apply(this, arguments);
                }
            }
            g.listener = listener;
            this.on(type, g);
            return this;
        };
        EventEmitter.prototype.removeListener = function(type, listener) {
            var list, position, length, i;
            if (!isFunction(listener)) throw TypeError("listener must be a function");
            if (!this._events || !this._events[type]) return this;
            list = this._events[type];
            length = list.length;
            position = -1;
            if (list === listener || isFunction(list.listener) && list.listener === listener) {
                delete this._events[type];
                if (this._events.removeListener) this.emit("removeListener", type, listener);
            } else if (isObject(list)) {
                for (i = length; i-- > 0; ) {
                    if (list[i] === listener || list[i].listener && list[i].listener === listener) {
                        position = i;
                        break;
                    }
                }
                if (position < 0) return this;
                if (list.length === 1) {
                    list.length = 0;
                    delete this._events[type];
                } else {
                    list.splice(position, 1);
                }
                if (this._events.removeListener) this.emit("removeListener", type, listener);
            }
            return this;
        };
        EventEmitter.prototype.removeAllListeners = function(type) {
            var key, listeners;
            if (!this._events) return this;
            if (!this._events.removeListener) {
                if (arguments.length === 0) this._events = {}; else if (this._events[type]) delete this._events[type];
                return this;
            }
            if (arguments.length === 0) {
                for (key in this._events) {
                    if (key === "removeListener") continue;
                    this.removeAllListeners(key);
                }
                this.removeAllListeners("removeListener");
                this._events = {};
                return this;
            }
            listeners = this._events[type];
            if (isFunction(listeners)) {
                this.removeListener(type, listeners);
            } else {
                while (listeners.length) this.removeListener(type, listeners[listeners.length - 1]);
            }
            delete this._events[type];
            return this;
        };
        EventEmitter.prototype.listeners = function(type) {
            var ret;
            if (!this._events || !this._events[type]) ret = []; else if (isFunction(this._events[type])) ret = [ this._events[type] ]; else ret = this._events[type].slice();
            return ret;
        };
        EventEmitter.listenerCount = function(emitter, type) {
            var ret;
            if (!emitter._events || !emitter._events[type]) ret = 0; else if (isFunction(emitter._events[type])) ret = 1; else ret = emitter._events[type].length;
            return ret;
        };
        function isFunction(arg) {
            return typeof arg === "function";
        }
        function isNumber(arg) {
            return typeof arg === "number";
        }
        function isObject(arg) {
            return typeof arg === "object" && arg !== null;
        }
        function isUndefined(arg) {
            return arg === void 0;
        }
    }, {} ],
    3: [ function(require, module, exports) {
        var process = module.exports = {};
        var queue = [];
        var draining = false;
        function drainQueue() {
            if (draining) {
                return;
            }
            draining = true;
            var currentQueue;
            var len = queue.length;
            while (len) {
                currentQueue = queue;
                queue = [];
                var i = -1;
                while (++i < len) {
                    currentQueue[i]();
                }
                len = queue.length;
            }
            draining = false;
        }
        process.nextTick = function(fun) {
            queue.push(fun);
            if (!draining) {
                setTimeout(drainQueue, 0);
            }
        };
        process.title = "browser";
        process.browser = true;
        process.env = {};
        process.argv = [];
        process.version = "";
        process.versions = {};
        function noop() {}
        process.on = noop;
        process.addListener = noop;
        process.once = noop;
        process.off = noop;
        process.removeListener = noop;
        process.removeAllListeners = noop;
        process.emit = noop;
        process.binding = function(name) {
            throw new Error("process.binding is not supported");
        };
        process.cwd = function() {
            return "/";
        };
        process.chdir = function(dir) {
            throw new Error("process.chdir is not supported");
        };
        process.umask = function() {
            return 0;
        };
    }, {} ],
    4: [ function(require, module, exports) {
        "use strict";
        var asap = require("asap/raw");
        function noop() {}
        var LAST_ERROR = null;
        var IS_ERROR = {};
        function getThen(obj) {
            try {
                return obj.then;
            } catch (ex) {
                LAST_ERROR = ex;
                return IS_ERROR;
            }
        }
        function tryCallOne(fn, a) {
            try {
                return fn(a);
            } catch (ex) {
                LAST_ERROR = ex;
                return IS_ERROR;
            }
        }
        function tryCallTwo(fn, a, b) {
            try {
                fn(a, b);
            } catch (ex) {
                LAST_ERROR = ex;
                return IS_ERROR;
            }
        }
        module.exports = Promise;
        function Promise(fn) {
            if (typeof this !== "object") {
                throw new TypeError("Promises must be constructed via new");
            }
            if (typeof fn !== "function") {
                throw new TypeError("not a function");
            }
            this._32 = 0;
            this._8 = null;
            this._89 = [];
            if (fn === noop) return;
            doResolve(fn, this);
        }
        Promise._83 = noop;
        Promise.prototype.then = function(onFulfilled, onRejected) {
            if (this.constructor !== Promise) {
                return safeThen(this, onFulfilled, onRejected);
            }
            var res = new Promise(noop);
            handle(this, new Handler(onFulfilled, onRejected, res));
            return res;
        };
        function safeThen(self, onFulfilled, onRejected) {
            return new self.constructor(function(resolve, reject) {
                var res = new Promise(noop);
                res.then(resolve, reject);
                handle(self, new Handler(onFulfilled, onRejected, res));
            });
        }
        function handle(self, deferred) {
            while (self._32 === 3) {
                self = self._8;
            }
            if (self._32 === 0) {
                self._89.push(deferred);
                return;
            }
            asap(function() {
                var cb = self._32 === 1 ? deferred.onFulfilled : deferred.onRejected;
                if (cb === null) {
                    if (self._32 === 1) {
                        resolve(deferred.promise, self._8);
                    } else {
                        reject(deferred.promise, self._8);
                    }
                    return;
                }
                var ret = tryCallOne(cb, self._8);
                if (ret === IS_ERROR) {
                    reject(deferred.promise, LAST_ERROR);
                } else {
                    resolve(deferred.promise, ret);
                }
            });
        }
        function resolve(self, newValue) {
            if (newValue === self) {
                return reject(self, new TypeError("A promise cannot be resolved with itself."));
            }
            if (newValue && (typeof newValue === "object" || typeof newValue === "function")) {
                var then = getThen(newValue);
                if (then === IS_ERROR) {
                    return reject(self, LAST_ERROR);
                }
                if (then === self.then && newValue instanceof Promise) {
                    self._32 = 3;
                    self._8 = newValue;
                    finale(self);
                    return;
                } else if (typeof then === "function") {
                    doResolve(then.bind(newValue), self);
                    return;
                }
            }
            self._32 = 1;
            self._8 = newValue;
            finale(self);
        }
        function reject(self, newValue) {
            self._32 = 2;
            self._8 = newValue;
            finale(self);
        }
        function finale(self) {
            for (var i = 0; i < self._89.length; i++) {
                handle(self, self._89[i]);
            }
            self._89 = null;
        }
        function Handler(onFulfilled, onRejected, promise) {
            this.onFulfilled = typeof onFulfilled === "function" ? onFulfilled : null;
            this.onRejected = typeof onRejected === "function" ? onRejected : null;
            this.promise = promise;
        }
        function doResolve(fn, promise) {
            var done = false;
            var res = tryCallTwo(fn, function(value) {
                if (done) return;
                done = true;
                resolve(promise, value);
            }, function(reason) {
                if (done) return;
                done = true;
                reject(promise, reason);
            });
            if (!done && res === IS_ERROR) {
                done = true;
                reject(promise, LAST_ERROR);
            }
        }
    }, {
             "asap/raw": 8
         } ],
    5: [ function(require, module, exports) {
        "use strict";
        var Promise = require("./core.js");
        var asap = require("asap/raw");
        module.exports = Promise;
        var TRUE = valuePromise(true);
        var FALSE = valuePromise(false);
        var NULL = valuePromise(null);
        var UNDEFINED = valuePromise(undefined);
        var ZERO = valuePromise(0);
        var EMPTYSTRING = valuePromise("");
        function valuePromise(value) {
            var p = new Promise(Promise._83);
            p._32 = 1;
            p._8 = value;
            return p;
        }
        Promise.resolve = function(value) {
            if (value instanceof Promise) return value;
            if (value === null) return NULL;
            if (value === undefined) return UNDEFINED;
            if (value === true) return TRUE;
            if (value === false) return FALSE;
            if (value === 0) return ZERO;
            if (value === "") return EMPTYSTRING;
            if (typeof value === "object" || typeof value === "function") {
                try {
                    var then = value.then;
                    if (typeof then === "function") {
                        return new Promise(then.bind(value));
                    }
                } catch (ex) {
                    return new Promise(function(resolve, reject) {
                        reject(ex);
                    });
                }
            }
            return valuePromise(value);
        };
        Promise.all = function(arr) {
            var args = Array.prototype.slice.call(arr);
            return new Promise(function(resolve, reject) {
                if (args.length === 0) return resolve([]);
                var remaining = args.length;
                function res(i, val) {
                    if (val && (typeof val === "object" || typeof val === "function")) {
                        if (val instanceof Promise && val.then === Promise.prototype.then) {
                            while (val._32 === 3) {
                                val = val._8;
                            }
                            if (val._32 === 1) return res(i, val._8);
                            if (val._32 === 2) reject(val._8);
                            val.then(function(val) {
                                res(i, val);
                            }, reject);
                            return;
                        } else {
                            var then = val.then;
                            if (typeof then === "function") {
                                var p = new Promise(then.bind(val));
                                p.then(function(val) {
                                    res(i, val);
                                }, reject);
                                return;
                            }
                        }
                    }
                    args[i] = val;
                    if (--remaining === 0) {
                        resolve(args);
                    }
                }
                for (var i = 0; i < args.length; i++) {
                    res(i, args[i]);
                }
            });
        };
        Promise.reject = function(value) {
            return new Promise(function(resolve, reject) {
                reject(value);
            });
        };
        Promise.race = function(values) {
            return new Promise(function(resolve, reject) {
                values.forEach(function(value) {
                    Promise.resolve(value).then(resolve, reject);
                });
            });
        };
        Promise.prototype["catch"] = function(onRejected) {
            return this.then(null, onRejected);
        };
    }, {
             "./core.js": 4,
             "asap/raw": 8
         } ],
    6: [ function(require, module, exports) {
        "use strict";
        var rawAsap = require("./raw");
        var freeTasks = [];
        var pendingErrors = [];
        var requestErrorThrow = rawAsap.makeRequestCallFromTimer(throwFirstError);
        function throwFirstError() {
            if (pendingErrors.length) {
                throw pendingErrors.shift();
            }
        }
        module.exports = asap;
        function asap(task) {
            var rawTask;
            if (freeTasks.length) {
                rawTask = freeTasks.pop();
            } else {
                rawTask = new RawTask();
            }
            rawTask.task = task;
            rawAsap(rawTask);
        }
        function RawTask() {
            this.task = null;
        }
        RawTask.prototype.call = function() {
            try {
                this.task.call();
            } catch (error) {
                if (asap.onerror) {
                    asap.onerror(error);
                } else {
                    pendingErrors.push(error);
                    requestErrorThrow();
                }
            } finally {
                this.task = null;
                freeTasks[freeTasks.length] = this;
            }
        };
    }, {
             "./raw": 7
         } ],
    7: [ function(require, module, exports) {
        (function(global) {
            "use strict";
            module.exports = rawAsap;
            function rawAsap(task) {
                if (!queue.length) {
                    requestFlush();
                    flushing = true;
                }
                queue[queue.length] = task;
            }
            var queue = [];
            var flushing = false;
            var requestFlush;
            var index = 0;
            var capacity = 1024;
            function flush() {
                while (index < queue.length) {
                    var currentIndex = index;
                    index = index + 1;
                    queue[currentIndex].call();
                    if (index > capacity) {
                        for (var scan = 0, newLength = queue.length - index; scan < newLength; scan++) {
                            queue[scan] = queue[scan + index];
                        }
                        queue.length -= index;
                        index = 0;
                    }
                }
                queue.length = 0;
                index = 0;
                flushing = false;
            }
            var BrowserMutationObserver = global.MutationObserver || global.WebKitMutationObserver;
            if (typeof BrowserMutationObserver === "function") {
                requestFlush = makeRequestCallFromMutationObserver(flush);
            } else {
                requestFlush = makeRequestCallFromTimer(flush);
            }
            rawAsap.requestFlush = requestFlush;
            function makeRequestCallFromMutationObserver(callback) {
                var toggle = 1;
                var observer = new BrowserMutationObserver(callback);
                var node = document.createTextNode("");
                observer.observe(node, {
                    characterData: true
                });
                return function requestCall() {
                    toggle = -toggle;
                    node.data = toggle;
                };
            }
            function makeRequestCallFromTimer(callback) {
                return function requestCall() {
                    var timeoutHandle = setTimeout(handleTimer, 0);
                    var intervalHandle = setInterval(handleTimer, 50);
                    function handleTimer() {
                        clearTimeout(timeoutHandle);
                        clearInterval(intervalHandle);
                        callback();
                    }
                };
            }
            rawAsap.makeRequestCallFromTimer = makeRequestCallFromTimer;
        }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {} ],
    8: [ function(require, module, exports) {
        (function(process) {
            "use strict";
            var domain;
            var hasSetImmediate = typeof setImmediate === "function";
            module.exports = rawAsap;
            function rawAsap(task) {
                if (!queue.length) {
                    requestFlush();
                    flushing = true;
                }
                queue[queue.length] = task;
            }
            var queue = [];
            var flushing = false;
            var index = 0;
            var capacity = 1024;
            function flush() {
                while (index < queue.length) {
                    var currentIndex = index;
                    index = index + 1;
                    queue[currentIndex].call();
                    if (index > capacity) {
                        for (var scan = 0, newLength = queue.length - index; scan < newLength; scan++) {
                            queue[scan] = queue[scan + index];
                        }
                        queue.length -= index;
                        index = 0;
                    }
                }
                queue.length = 0;
                index = 0;
                flushing = false;
            }
            rawAsap.requestFlush = requestFlush;
            function requestFlush() {
                var parentDomain = process.domain;
                if (parentDomain) {
                    if (!domain) {
                        domain = require("domain");
                    }
                    domain.active = process.domain = null;
                }
                if (flushing && hasSetImmediate) {
                    setImmediate(flush);
                } else {
                    process.nextTick(flush);
                }
                if (parentDomain) {
                    domain.active = process.domain = parentDomain;
                }
            }
        }).call(this, require("_process"));
    }, {
             _process: 3,
             domain: 1
         } ],
    9: [ function(require, module, exports) {
        if (typeof Promise.prototype.done !== "function") {
            Promise.prototype.done = function(onFulfilled, onRejected) {
                var self = arguments.length ? this.then.apply(this, arguments) : this;
                self.then(null, function(err) {
                    setTimeout(function() {
                        throw err;
                    }, 0);
                });
            };
        }
    }, {} ],
    10: [ function(require, module, exports) {
        var asap = require("asap");
        if (typeof Promise === "undefined") {
            Promise = require("./lib/core.js");
            require("./lib/es6-extensions.js");
        }
        require("./polyfill-done.js");
    }, {
              "./lib/core.js": 4,
              "./lib/es6-extensions.js": 5,
              "./polyfill-done.js": 9,
              asap: 6
          } ]
}, {}, [ 10 ]);
