![Requirements](bin/images/Readme.jpg)

Requirements
============

This package provides methods to check the system requirements for QUIQQER

Package name:

    quiqqer/requirements


Features
--------

System requirements check.

The following tests are currently implemented:

* PHP Version greater than 5.6
* PHP memory limit >256M
* PHP extension: PDO (MySql)
* PHP extension: DOM
* PHP extension: Curl
* PHP extension: JSON
* PHP extension: Image (GD | Imagick)
* PHP extension: Gzip
* PHP extension: MBstring
* Apache: Mod rewrite

_This list might not be up to date. Check `src/QUI/Requirements/Tests` folder to see all tests._


Usage
-----

For usage examples please check the `examples` folder.


Ignore specific Tests
---------------------

It is possible to ignore specific tests or groups.

```php
$Requirements = new \QUI\Requirements\Requirements();
   
$Tests = $Requirements->getTests(array(
    'path.within.tests.directory', //Group identifier
    'test.identifier'
));

print_r($Tests);
```

You can provide multiple identifiers in an array.  
Every test has an identifier, which you can find in the test's properties:
```php
class Memorylimit extends Test
{
    protected $identifier = 'php.configuration.memorylimit';
[...]
```

Each group has an identifier as well.  
The group identifiers are built by their namespace and hence by their location within the test's directory.

To get the group identifier from a path:
1. Remove the `src/QUI/Requirements/Tests/` part
2. Replace slashes `/` with dots (`.`)
3. Change all letters to lowercase

Example:
`src/QUI/Requirements/Tests/PHP/Configuration` becomes `php.configuration`.


Test Components
--------------

A test consists of the following components:
* A name
* A description
* A result
  * Statuscode
  * Reason / message


Test Results
-----------

Each test will yield a TestResult. These TestResults have a status code and a reason/message tied to them.

The status codes are integers and defined by constants in the `TestResult` class.  
The following status codes are implemented:

| Status Code         | Explanation |
| ------------------- | ----------- |
| STATUS_FAILED (0)   | The test failed and QUIQQER will not work on this system. |
| STATUS_OK (1)       | The test passed. |
| STATUS_UNKNOWN (2)  | The test could not determine a proper result (e.g. `ApacheRewrite` can't be detected by PHP) |
| STATUS_WARNING (3)  | The test yielded a warning that might cause problems in the future (e.g. RAM is sufficient but more is recommended) |
| STATUS_OPTIONAL (4) | An optional component is missing which would be nice to have. |

_This list might not be up to date. Check `src/QUI/Requirements/TestResult` class to see all status codes._


Adding new tests
----------------

To add new tests you need to create a new class in the folder `src/QUI/Requirements/Tests`.  
The class has to extend the abstract class `QUI\Requirements\Tests\Test`.  
The class has to provide the property `protected $identifier=''`.  
The location of the class must comply with the PSR-4 standard and its namespace is used as its group.

Now you need to add the following locale variables:

* `requirements.tests.<your identifier here>.name` // Test name
* `requirements.tests.<your identifier here>.desc` // Test description
* `requirements.tests.groups.<namespace identifier>` // Test group name

See the `Ignoring specific tests` section on how to get the `<namespace identifier>`.

**Example skeleton:**

```php
namespace QUI\Requirements\Tests\ExampleGroup;

use QUI\Requirements\Locale;
use QUI\Requirements\TestResult;
use QUI\Requirements\Tests\Test;


class ExampleTest extends Test
{
    protected $identifier = "examplegroup.exampletest";

    public function run()
    {
        // Execute your test logic here

        // Return a fitting TestResult object
        return new TestResult(TestResult::STATUS_OK, "Everything is all right!");
    }
}
```


Installation
------------

The package name is: `quiqqer/requirements`


Contribute
----------

- Issue Tracker: https://dev.quiqqer.com/quiqqer/requirements/issues
- Source Code: https://dev.quiqqer.com/quiqqer/requirements
- Wiki: https://dev.quiqqer.com/quiqqer/requirements/wikis/home


Support
-------

If you found any flaws, have any wishes or suggestions you can email [support@pcsg.de](mailto:support@pcsg.de) to inform us about your concerns.  
We will try to respond to your request and forward it to the responsible developer.


License
------

GPL-3.0+
