<?php

namespace QUI\Requirements;

use Exception;
use QUI;
use QUI\Cron\Manager;
use QUI\Requirements\Tests\Quiqqer\Checksums;

/**
 * Class Cron
 *
 * @package QUI\Requirements
 */
class Cron
{
    /**
     * @param $params
     * @param $CronManager
     *
     * @throws Exception
     */
    public static function executeChecksumTest($params, $CronManager): void
    {
        // Notify the admins about a misconfiguration
        if (!isset($params['email'])) {
            $AdminUsers = QUI::getUsers()->getUsers([
                "where" => [
                    "su" => 1
                ]
            ]);

            foreach ($AdminUsers as $AdminUser) {
                QUI::getMessagesHandler()->sendAttention(
                    $AdminUser,
                    QUI::getLocale()->get("quiqqer/requirements", "cron.test.checksums.error.email.missing")
                );
            }

            return;
        }

        $email = $params['email'];

        if (!isset($params['sendOnWarning'])) {
            $params['sendOnWarning'] = false;
        }

        $sendOnWarning = $params['sendOnWarning'];

        $Test = new Checksums();
        $TestResult = $Test->getResult();

        if ($TestResult->getStatus() == TestResult::STATUS_OK) {
            return;
        }

        if (!$sendOnWarning && $TestResult->getStatus() == TestResult::STATUS_WARNING) {
            return;
        }

        // Send mail
        $subject = QUI::getLocale()->get("quiqqer/requirements", "cron.test.checksums.mail.subject");
        $subject .= " - " . QUI::conf("globals", "host");

        // Hide valid files & packages
        $body = "<style>
                    .package-ok {display:none}
                    .tr-ok{display: none}
        </style>";

        // Hide warnings if only errors are relevant
        if (!$sendOnWarning) {
            $body = $body . "<style>
                    .package-warning {display:none}
                    .tr-warning{display: none}
            </style>";
        }

        $body = $body . Locale::getInstance()->get("checksums.cron.email.intro") . "<br />";
        $body = $body . $TestResult->getMessage();

        QUI::getMailManager()->send($email, $subject, $body);
    }

    /**
     * Checks the system health.
     * Runs the system check and stores the results' statuses
     *
     * @param $params
     * @param Manager $CronManager
     */
    public static function storeSystemCheckResults($params, Manager $CronManager): void
    {
        Utils::getSystemCheckResults(true);
    }
}
