<?php

namespace QUI\Requirements\Tests\PHP\Modules;

use Exception;
use QUI\Requirements\Locale;
use QUI\Requirements\TestResult;
use QUI\Requirements\Tests\Test;

use function class_exists;

/**
 * Class PDO
 * @package QUI\Requirements\Tests\PHP\Modules
 */
class Intl extends Test
{
    /**
     * @var string
     */
    protected string $identifier = "php.modules.intl";

    /**
     * @return TestResult
     * @throws Exception
     */
    protected function run(): TestResult
    {
        if (!class_exists('IntlDateFormatter')) {
            return new TestResult(
                TestResult::STATUS_FAILED,
                Locale::getInstance()->get('requirements.error.module.intl.missing')
            );
        }

        return new TestResult(TestResult::STATUS_OK);
    }
}
