<?php

namespace QUI\Requirements\Tests\PHP\Modules;

use Exception;
use QUI\Requirements\Locale;
use QUI\Requirements\TestResult;
use QUI\Requirements\Tests\Test;

/**
 * Class PDO
 * @package QUI\Requirements\Tests\PHP\Modules
 */
class Xml extends Test
{
    /**
     * @var string
     */
    protected string $identifier = "php.modules.xml";

    /**
     * @return TestResult
     * @throws Exception
     */
    protected function run(): TestResult
    {
        if (!extension_loaded('xml')) {
            return new TestResult(
                TestResult::STATUS_FAILED,
                Locale::getInstance()->get('requirements.error.module.xml.missing')
            );
        }

        return new TestResult(TestResult::STATUS_OK);
    }
}
