<?php

namespace QUI\Requirements\Tests\PHP;

use Exception;
use QUI\Requirements\Locale;
use QUI\Requirements\TestResult;
use QUI\Requirements\Tests\Test;

use function defined;
use function file_exists;
use function file_get_contents;
use function json_decode;

/**
 * Class Version
 *
 * @package QUI\Requirements\Tests\PHP
 */
class Version extends Test
{
    /**
     * @var string
     */
    protected string $identifier = "php.version";

    /**
     * @return TestResult
     * @throws Exception
     */
    protected function run(): TestResult
    {
        $requiredVersion = '7.4';

        if (defined('OPT_DIR')) {
            $composer = OPT_DIR . 'quiqqer/core/composer.json';

            if (file_exists($composer)) {
                $composerJson = file_get_contents($composer);
                $composerJson = json_decode($composerJson, true);
                $requiredVersion = $composerJson['require']['php'];
            }
        }


        if (!version_compare(phpversion(), $requiredVersion, '>=')) {
            return new TestResult(
                TestResult::STATUS_FAILED,
                Locale::getInstance()->get("requirements.error.version.insufficient")
            );
        }

        $okMessage = Locale::getInstance()->get("requirements.message.version.ok");
        $okMessage = str_replace("%VERSION%", phpversion(), $okMessage);
        $okMessage = str_replace("%REQUIRED_VERSION%", $requiredVersion, $okMessage);

        return new TestResult(
            TestResult::STATUS_OK,
            $okMessage
        );
    }
}
