<?php

/**
 * This file contains QUI\Slider\Bricks\ScrollingStrip
 */

namespace QUI\Slider\Bricks;

use QUI;

/**
 * Class ScrollingStrip
 *
 * @package QUI\Slider\Controls
 * @author  www.pcsg.de (Michael Danielczok)
 */
class ScrollingStrip extends QUI\Control
{
    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        // default options
        $this->setAttributes([
            'class' => 'quiqqer-slider-bricks-scrollingStrip',
            'nodeName' => 'section',
            'folderId' => null,
            'order' => 'random',
            'imageMaxHeight' => 80, // in px
            'entries' => [], // array or valid json string
            'verticalAlign' => 'stretch', // stretch / flex-start / center / flex-end
            'animationDirection' => 'toLeft', // toLeft / toRight
            'animationDuration' => 60000, // in ms
            'pauseOnHover' => true,
            'dimItemsUntilHover' => true // dim (grayscale and opacity) items until hover
        ]);

        parent::__construct($attributes);
    }

    /**
     * (non-PHPdoc)
     *
     * @see \QUI\Control::create()
     */
    public function getBody(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine();
        $entries = $this->getAttribute('entries');

        if (is_string($entries)) {
            $entries = json_decode($entries, true);

            if (!is_array($entries)) {
                QUI\System\Log::addWarning('Invalid JSON entries for ScrollingStrip', [
                    'class' => static::class,
                    'method' => __METHOD__,
                    'rawEntries' => $this->getAttribute('entries')
                ]);

                $entries = [];
            }
        } elseif (!is_array($entries)) {
            $entries = [];
        }

        if (empty($entries)) {
            QUI\System\Log::addWarning('No entries found for ScrollingStrip', [
                'class' => static::class,
                'method' => __METHOD__,
                'file' => __FILE__,
                'line' => __LINE__
            ]);

            return '';
        }

        foreach ($entries as $key => $entry) {
            if (isset($entry['isDisabled']) && $entry['isDisabled']) {
                unset($entries[$key]);
            }
        }

        $ScrollingStrip = new QUI\Slider\Controls\ScrollingStrip([
            'folderId' => $this->getAttribute('folderId'),
            'order' => $this->getAttribute('order'),
            'imageMaxHeight' => $this->getAttribute('imageMaxHeight'),
            'entries' => $entries,
            'verticalAlign' => $this->getAttribute('verticalAlign'),
            'animationDirection' => $this->getAttribute('animationDirection'),
            'animationDuration' => $this->getAttribute('animationDuration'),
            'pauseOnHover' => $this->getAttribute('pauseOnHover'),
            'dimItemsUntilHover' => $this->getAttribute('dimItemsUntilHover')
        ]);

        $Engine->assign([
            'this' => $this,
            'ScrollingStrip' => $ScrollingStrip
        ]);

        return $Engine->fetch(dirname(__FILE__) . '/ScrollingStrip.html');
    }
}
