<?php

/**
 * This file contains \QUI\Slider\Controls\Logo\Carousel
 */

namespace QUI\Slider\Controls\Logo;

use QUI;
use QUI\Projects\Media\Folder;

use function array_slice;
use function count;
use function dirname;

/**
 * Class Carousel
 */
class Carousel extends QUI\Control
{
    /**
     * constructor
     *
     * @param array<string, mixed> $attributes
     */
    public function __construct(array $attributes = [])
    {
        // default options
        $this->setAttributes([
            'class' => 'quiqqer-slider-logoCarousel',
            'nodeName' => 'section',
            'site' => '',
            'Project' => false,
            'folderId' => false,
            'perView' => 3,
            'maxImgHeight' => 100,
            'delay' => 3000,
            'minSlideWidth' => 150,
            'logoBackgroundColor' => false,
            'order' => false,
            'data-qui' => 'package/quiqqer/slider/bin/Logo/Carousel',
            'grayscale' => false,
            'hoverpause' => false
        ]);

        $this->addCSSFile(
            dirname(__FILE__) . '/Carousel.css'
        );

        parent::__construct($attributes);
    }

    public function getBody(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine();
        $Project = $this->getProject();
        $Media = $Project->getMedia();
        $folderId = $this->getAttribute('folderId');
        $Folder = false;

        $maxImageHeight = '200px';
        if ($this->getAttribute('maxImgHeight') != '') {
            $maxImageHeight = $this->getAttribute('maxImgHeight');
        }

        $perView = 3;
        if ($this->getAttribute('perView') != '') {
            $perView = $this->getAttribute('perView');
        }

        $delay = 2000;
        if ($this->getAttribute('delay') != '') {
            $delay = $this->getAttribute('delay');
        }

        $grayscale = false;
        if ($this->getAttribute('grayscale') != '') {
            $grayscale = $this->getAttribute('grayscale');
        }

        $hoverpause = false;
        if ($this->getAttribute('hoverpause') != '') {
            $hoverpause = $this->getAttribute('hoverpause');
        }

        $minSlideWidth = 150;
        if ($this->getAttribute('minSlideWidth') != '') {
            $minSlideWidth = $this->getAttribute('minSlideWidth');
        }

        $this->setJavaScriptControlOption('perview', intval($perView));
        $this->setJavaScriptControlOption('delay', intval($delay));
        $this->setJavaScriptControlOption('hoverpause', boolval($hoverpause));
        $this->setJavaScriptControlOption('minslidewidth', intval($minSlideWidth));

        /* @var $Folder Folder */
        if (str_contains($folderId, 'image.php')) {
            try {
                $Folder = QUI\Projects\Media\Utils::getMediaItemByUrl(
                    $folderId
                );
            } catch (QUI\Exception) {
            }
        } elseif ($folderId) {
            try {
                $Folder = $Media->get((int)$folderId);
            } catch (QUI\Exception) {
            }
        }

        switch ($this->getAttribute('order')) {
            case 'title DESC':
            case 'title ASC':
            case 'name DESC':
            case 'name ASC':
            case 'c_date DESC':
            case 'c_date ASC':
            case 'e_date DESC':
            case 'e_date ASC':
            case 'priority DESC':
            case 'priority ASC':
                $order = $this->getAttribute('order');
                break;

            default:
                $order = 'name DESC';
                break;
        }

        $images = [];

        if (is_object($Folder) && method_exists($Folder, 'getImages')) {
            $images = $Folder->getImages([
                'order' => $order
            ]);
        }

        if ($this->getAttribute('max') && count($images) > $this->getAttribute('max')) {
            $images = array_slice($images, 0, $this->getAttribute('max'));
        }

        $this->setStyles([
            '--qui--logoCarousel-height' => $maxImageHeight . "px"
        ]);

        $Engine->assign([
            'this' => $this,
            'images' => $images,
            'maxImgHeight' => $maxImageHeight,
            'grayscale' => $grayscale,
            'logoBackgroundColor' => $this->getAttribute('logoBackgroundColor')
        ]);

        return $Engine->fetch($this->getTemplate());
    }

    /**
     * Return the control template
     *
     * @return string
     */
    protected function getTemplate(): string
    {
        return dirname(__FILE__) . '/Carousel.html';
    }
}
