<?php

/**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage plugins
 */

/**
 * Smarty {user id=user_id} function plugin
 *
 * Type:     function<br>
 * Name:     user<br>
 *
 * @param array $params
 * @param Smarty $Smarty
 *
 * @author Henning Leutz <henbug @ pcsg . de>
 *
 */
function smarty_function_user($params, $Smarty): void
{
    if (empty($params['id'])) {
        $Smarty->assign($params['var'], QUI::getUsers()->getNobody());
        return;
    }

    try {
        $User = QUI::getUsers()->get($params['id']);
    } catch (QUI\Exception) {
        $User = QUI::getUsers()->getNobody();
    }

    $Smarty->assign($params['var'], $User);
}
