<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\System\Log;

/**
 * Smarty {object} function plugin
 *
 * File:     function.object.php<br>
 * Type:     function<br>
 * Name:     object<br>
 * Purpose:  creates an object
 *
 * @param array $params parameters
 * @param $Smarty
 * @return string|object
 *
 * @example {object class="\My\Namspace" assign=Obj}
 */
function smarty_function_object($params, $Smarty): string|object
{
    if (!isset($params['class'])) {
        return '';
    }

    $assign = $params['assign'] ?? false;
    $class = $params['class'];

    unset($params['class']);
    unset($params['assign']);

    if (!count($params)) {
        $Object = new $class();
    } else {
        try {
            $Reflection = new ReflectionClass($class);
            $Object = $Reflection->newInstanceArgs($params);
        } catch (Exception $Exception) {
            Log::writeException($Exception);

            return '';
        }
    }

    if (!$assign) {
        return $Object;
    }

    $Smarty->assign($assign, $Object);

    return '';
}
