<?php

/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * Smarty {explode var= delimiter= assign=} function plugin
 *
 * Type:     function<br>
 * Name:     explode<br>
 * @param array $params
 * @param Smarty $Smarty
 * @return array|null
 * @author Henning Leutz <leutz@pcsg.de>
 */
function smarty_function_explode($params, $Smarty): ?array
{
    if (!isset($params['var'])) {
        return null;
    }

    if (!isset($params['delimiter'])) {
        return null;
    }

    $result = explode($params['delimiter'], $params['var']);

    foreach ($result as $key => $value) {
        if (empty($value)) {
            unset($result[$key]);
        }
    }

    if (!isset($params['assign'])) {
        return $result;
    }

    $Smarty->assign($params['assign'], $result);
    return null;
}
