<?php

/**
 * This file contains QUI\Smarty\Collector
 */

namespace QUI\Smarty;

/**
 * Class Collector
 * HTML Smarty Collector for {templateEvent}
 *
 * @package QUI\Smarty
 */
class Collector
{
    /**
     * Internal Content
     *
     * @var string
     */
    protected string $content = '';

    /**
     * @param string $content
     */
    public function append(string $content): void
    {
        $this->content .= $content;
    }

    /**
     * Return the collected content
     *
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * clear the collector
     */
    public function clear(): void
    {
        $this->content = '';
    }
}
