<?php

namespace QUI\Smarty\plugins_qui;

use Exception;
use QUI;

use function explode;
use function file_exists;
use function implode;
use function method_exists;
use function str_replace;

/**
 * Class QuiqqerTemplateFetch
 *
 * Responsible for fetching template files via Smarty.
 * This overwrites the default Smarty "fetch" method!
 *
 * @todo globale Smarty get Filename einführen
 * @todo getFilename dann nutzen
 */
class QuiqqerTemplateFetch
{
    /**
     * @param array $params
     * @param $Smarty
     *
     * @return string
     *
     * @throws QUI\Exception
     */
    public static function fetch(array $params, $Smarty): string
    {
        if (empty($params['template'])) {
            return '';
        }

        $file = $params['template'];
        $originalFile = $file;
        $Project = QUI::getRewrite()->getProject();

        if (
            !empty($params['Template'])
            && $params['Template'] instanceof QUI\Template
            && method_exists($params['Template'], 'getTemplatePath')
        ) {
            $templatePath = $params['Template']->getTemplatePath();
        } else {
            $templatePath = OPT_DIR . $Project->getAttribute('template') . '/';
        }

        if (QUI::getRewrite()->getSite()) {
            $Site = QUI::getRewrite()->getSite();

            try {
                $ownTemplate = $Site->getAttribute('quiqqer.site.template');
                $Package = QUI::getPackage($ownTemplate);
                $templatePath = OPT_DIR . $Package->getName() . '/';

                if (method_exists($Package, 'getTemplateParent')) {
                    $TemplateParent = $Package->getTemplateParent();

                    if ($TemplateParent) {
                        $templatePath = OPT_DIR . $TemplateParent->getName() . '/';
                    }
                }
            } catch (QUI\Exception) {
            }
        }

        if (!file_exists($templatePath)) {
            QUI\System\Log::addError('Template path "' . $templatePath . '" not found.');

            return '';
        }

        $file = $templatePath . $file;

        if (!file_exists($file)) {
            try {
                // consider template parent if not exist
                $file = str_replace(OPT_DIR, '', $file);
                $file = explode(DIRECTORY_SEPARATOR, $file);

                $package = $file[0] . DIRECTORY_SEPARATOR . $file[1];
                $Package = QUI::getPackage($package);

                unset($file[0]);
                unset($file[1]);

                if (method_exists($Package, 'getTemplateParent')) {
                    $TemplateParent = $Package->getTemplateParent();

                    if (empty($TemplateParent)) {
                        QUI\System\Log::addError('Template parent not found.');
                        return '';
                    }

                    $file = OPT_DIR .
                        $TemplateParent->getName() .
                        DIRECTORY_SEPARATOR .
                        implode(DIRECTORY_SEPARATOR, $file);

                    if (!file_exists($file) && file_exists($originalFile)) {
                        $file = $originalFile;
                    }

                    if (!file_exists($file)) {
                        QUI\System\Log::addError('Template file "' . $file . '" not found.');

                        return '';
                    }
                }
            } catch (Exception $Exception) {
                QUI\System\Log::addError('Template file not found.', [
                    'templateFile' => $file
                ]);

                QUI\System\Log::addError($Exception->getMessage());

                return '';
            }
        }


        $Engine = QUI::getTemplateManager()->getEngine();
        $Engine->assign($params);

        return $Engine->fetch($file);
    }
}
