<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\Control;

/**
 * Smarty {control} function plugin
 *
 * File:     function.control.php<br>
 * Type:     function<br>
 * Name:     array<br>
 * Purpose:  creates a control
 *
 * @param array $params parameters
 * @param Smarty|Smarty_Internal_Template $Smarty Smarty object
 * @return string
 */
function smarty_function_control(array $params, $Smarty): string
{
    if (!isset($params['control'])) {
        return '';
    }

    // #quiqqer/quiqqer#1079
    $control = $params['control'];

    if (class_exists('QUI\Bricks\Manager')) {
        $Project = $Smarty->getTemplateVars('Project');
        $template = false;

        if ($Project && $Project->getAttribute('template')) {
            $template = $Project->getAttribute('template');
        }

        $control = QUI\Bricks\Manager::init()->getAlternateClass($control, $template);
    }

    try {
        if (!class_exists($control)) {
            throw new QUI\Exception('Control not found: ' . $control);
        }

        /* @var $Control Control */
        $Control = new $control();
    } catch (QUI\Exception $Exception) {
        QUI\System\Log::writeException($Exception);

        return '';
    }

    $assign = $params['assign'] ?? false;

    unset($params['control']);
    unset($params['assign']);

    $Control->setAttributes($params);

    if (!$Control->getAttribute('Site')) {
        $Control->setAttribute('Site', $Smarty->getTemplateVars('Site'));
        $Control->setAttribute('Project', $Smarty->getTemplateVars('Project'));
    }

    if (!$assign) {
        if (method_exists($Control, 'create')) {
            try {
                return $Control->create();
            } catch (QUI\Exception $Exception) {
                QUI\System\Log::writeException($Exception);
            }
        }

        return '';
    }

    $Smarty->assign($assign, $Control);

    return '';
}
