<?php

/**
 * Smarty Plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 *
 * @author     PCSG - Henning
 */

/**
 * Smarty {json_decode} function plugin
 *
 * Type:     function<br>
 * Name:     url<br>
 *
 * @param array $params
 * @param Smarty $Smarty
 *
 * @return string|null
 * @author PCSG
 */
function smarty_function_json_encode($params, $Smarty): ?string
{
    if (!isset($params['var'])) {
        return null;
    }

    $arr = json_encode($params['var']);

    if (!isset($params['assign'])) {
        return $arr;
    }

    $Smarty->assign($params['assign'], $arr);
    return null;
}
